#include <bits/stdc++.h>
using namespace std;

using ll = long long;
using ld = long double;
using pii = pair<int, int>;
using pll = pair<ll, ll>;
using vi = vector<int>;
using vll = vector<ll>;

const int MOD = 1e9 + 7;
const int INF = 1e9;
const ll LINF = 1e18;
const ld EPS = 1e-9;

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define pb push_back
#define eb emplace_back
#define fi first
#define se second
#define sz(x) ((int)(x).size())

const int MAX_N = 1000;
const int MAX_M = 1000;

int N, M;
char lavirint[MAX_N][MAX_M];
int vreme_vatre[MAX_N][MAX_M];
int vreme_steve[MAX_N][MAX_M];
int dx[4] = {-1, 1, 0, 0};
int dy[4] = {0, 0, -1, 1};

void bfs(int vreme[][MAX_M], queue<pii> &q) {

    while(!q.empty()) {
        pii tr = q.front();
        q.pop();
        int x = tr.fi;
        int y = tr.se;
        for(int d = 0; d < 4; d++) {
            int nx = x + dx[d];
            int ny = y + dy[d];
            if(nx >= 0 && nx < N && ny >=0 && ny < M && lavirint[nx][ny] != '*') {
                if(vreme[nx][ny] == INF) {
                    vreme[nx][ny] = vreme[x][y] + 1;
                    q.push({nx, ny});
                }
            }
        }
    }
}

void solve() {

    cin >> N >> M;
    int x = -1, y = -1;
    queue<pii> q1;
    for(int i = 0; i < N; i++) {
        string red;
        cin >> red;
        for(int j = 0; j < M; j++) {
            lavirint[i][j] = red[j];
            if(red[j] == 'S') {
                x = i;
                y = j;
            }
            if(red[j] == 'X') {
                vreme_vatre[i][j] = 0;
                q1.push({i, j});
            } else {
                vreme_vatre[i][j] = INF;
            }
            vreme_steve[i][j] = INF;
        }
    }
    bfs(vreme_vatre, q1);
    if(x != -1 && y != -1){
        vreme_steve[x][y] = 0;
        queue<pii> q2;
        q2.push({x, y});
        bfs(vreme_steve, q2);
    }
    int cnt = 0;
    for(int i = 0; i < N; i++) {
        for(int j = 0; j < M; j++) {
            if(lavirint[i][j] != '*') {
                if(vreme_steve[i][j] < vreme_vatre[i][j]) {
                    cnt++;
                }
            }
        }
    }
    cout << cnt;
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int t = 1;
    // cin >> t;
    while (t--) solve();
    return 0;
}