#include <iostream>
#include <vector>
#include <queue>
using namespace std;

struct Pozicija {
    int red, kolona;
    int vreme;
    Pozicija(int r, int k, int v) : red(r), kolona(k), vreme(v) {}
};

const int dx[] = { -1, 0, 1, 0 };
const int dy[] = { 0, 1, 0, -1 };

vector<vector<char>> lavirint;
vector<vector<int>> vremeVatre;
vector<vector<int>> vremeDolaskaSteve;
int n, m;
int stevaRed, stevaKolona;

void prosiriVatru() {
    queue<Pozicija> red;
    vremeVatre = vector<vector<int>>(n, vector<int>(m, 1e9));

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            if (lavirint[i][j] == 'X') {
                red.push(Pozicija(i, j, 0));
                vremeVatre[i][j] = 0;
            }
        }
    }

    while (!red.empty()) {
        Pozicija trenutna = red.front();
        red.pop();

        for (int d = 0; d < 4; d++) {
            int noviRed = trenutna.red + dx[d];
            int novaKolona = trenutna.kolona + dy[d];

            if (noviRed >= 0 && noviRed < n && novaKolona >= 0 && novaKolona < m &&
                lavirint[noviRed][novaKolona] != '*' &&
                vremeVatre[noviRed][novaKolona] > trenutna.vreme + 1) {
                vremeVatre[noviRed][novaKolona] = trenutna.vreme + 1;
                red.push(Pozicija(noviRed, novaKolona, trenutna.vreme + 1));
            }
        }
    }
}

void nadjiStevinePutanje() {
    queue<Pozicija> red;
    vremeDolaskaSteve = vector<vector<int>>(n, vector<int>(m, 1e9));

    red.push(Pozicija(stevaRed, stevaKolona, 0));
    vremeDolaskaSteve[stevaRed][stevaKolona] = 0;

    while (!red.empty()) {
        Pozicija trenutna = red.front();
        red.pop();

        for (int d = 0; d < 4; d++) {
            int noviRed = trenutna.red + dx[d];
            int novaKolona = trenutna.kolona + dy[d];

            if (noviRed >= 0 && noviRed < n && novaKolona >= 0 && novaKolona < m &&
                lavirint[noviRed][novaKolona] != '*' &&
                vremeDolaskaSteve[noviRed][novaKolona] > trenutna.vreme + 1) {
                vremeDolaskaSteve[noviRed][novaKolona] = trenutna.vreme + 1;
                red.push(Pozicija(noviRed, novaKolona, trenutna.vreme + 1));
            }
        }
    }
}

int izracunajBezbednaPolja() {
    int bezbednaPolja = 0;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            if (lavirint[i][j] != '*' && vremeDolaskaSteve[i][j] < vremeVatre[i][j]) {
                bezbednaPolja++;
            }
        }
    }
    return bezbednaPolja;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    cin >> n >> m;
    lavirint = vector<vector<char>>(n, vector<char>(m));

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            cin >> lavirint[i][j];
            if (lavirint[i][j] == 'S') {
                stevaRed = i;
                stevaKolona = j;
            }
        }
    }

    prosiriVatru();
    nadjiStevinePutanje();
    cout << izracunajBezbednaPolja() << '\n';

    return 0;
}