class Mapa:
    class inner_list:
        def __init__(self, val):
            self.l = val

        def append(self, item):
            self.l.append(item)

        def __getitem__(self, item):
            if isinstance(item, int) and item >= 0 and item <= len(self.l) - 1:
                return self.l[item]
            else:
                #print(item, self.l)
                return Mapa.inner_list(['?'])

        def __setitem__(self, item, val):
            if isinstance(item, int) and item >= 0 and item <= len(self.l) - 1:
                self.l[item] = val
            else:
                return

        def __len__(self):
            return len(self.l)
        
    
    def __init__(self, v, s):
        self.visina = v
        self.sirina = s
        self.mapa = self.inner_list([])

        self.gen_map(self.sirina, self.visina)

    @classmethod
    def from_string(cls, s):
        m = cls(len(s.split('\n')), len(s.split('\n')[0]))

        for y in range(m.visina):
            red = s.split('\n')[y]

            for x in range(0, len(red)):
                m[x][y] = red[x]

        return m

    def gen_map(self, s, v):
        for x in range(s):
            self.mapa.append( self.inner_list(['.' for i in range(v)]) )

    def loop_through(self):
        for x in range(self.sirina):
            for y in range(self.visina):
                yield (x, y)

    def find_steva(self):
        for x, y in self.loop_through():
            if self[x][y] == 'S':
                return (x, y)

    def turn(self):
        #vatra
        turns = [(-1, 0), (1, 0), (0, -1), (0, 1)]
        blacklist = []

        for x, y in self.loop_through():
            if (x, y) not in blacklist and self[x][y] == 'X':
                for turn_x, turn_y in turns:
                    if self[x + turn_x][y + turn_y] == '.':
                        self[x + turn_x][y + turn_y] = 'X'
                        blacklist.append((x + turn_x, y + turn_y))

        #steva
        for x, y in self.loop_through():
            if (x, y) not in blacklist and self[x][y] == 'S':
                for turn_x, turn_y in turns:
                    if self[x + turn_x][y + turn_y] == '.':
                        self[x + turn_x][y + turn_y] = 'S'
                        blacklist.append((x + turn_x, y + turn_y))

        return True if len(blacklist) > 0 else False

    def turn_until_stagnation(self):
        while self.turn():
            pass
        

    def __getitem__(self, item):
        return self.mapa[item]

    def __str__(self):
        s = ''
    
        for i in range(len(self[0])):
            for ii in range(len(self.mapa)):
                s += self[ii][i]
            s += '\n'

        return s


visina, sirina = [ int(x) for x in input().split(' ') ]
mapa = Mapa.from_string('\n'.join([ input() for x in range(visina) ]))

mapa.turn_until_stagnation()
    
print(str(mapa))