pravci = [(-1, 0), (1, 0), (0, -1), (0, 1)]

def bfs_vatra(startne_pozicije, n, m, lavirint):
    vreme_vatre = [[float('inf')] * m for _ in range(n)]
    red = startne_pozicije[:]
    
    for x, y in red:
        vreme_vatre[x][y] = 0
    
    for x, y in red:
        trenutno_vreme = vreme_vatre[x][y]
        
        for dx, dy in pravci:
            nx, ny = x + dx, y + dy
            if 0 <= nx < n and 0 <= ny < m and lavirint[nx][ny] == '.' and vreme_vatre[nx][ny] == float('inf'):
                vreme_vatre[nx][ny] = trenutno_vreme + 1
                red.append((nx, ny))

    return vreme_vatre

def bfs_steva(start_x, start_y, n, m, lavirint, vreme_vatre):
    vreme_steve = [[float('inf')] * m for _ in range(n)]
    red = [(start_x, start_y)]
    vreme_steve[start_x][start_y] = 0
    
    while red:
        x, y = red.pop(0)
        trenutno_vreme = vreme_steve[x][y]
        
        for dx, dy in pravci:
            nx, ny = x + dx, y + dy
            if 0 <= nx < n and 0 <= ny < m and lavirint[nx][ny] == '.' and vreme_steve[nx][ny] == float('inf'):
                if trenutno_vreme + 1 < vreme_vatre[nx][ny]:
                    vreme_steve[nx][ny] = trenutno_vreme + 1
                    red.append((nx, ny))
    
    return vreme_steve

def resi():
    n, m = map(int, input().split())
    lavirint = [input().strip() for _ in range(n)]
    
    pozicije_vatre = []
    pozicija_steve = None
    
    for i in range(n):
        for j in range(m):
            if lavirint[i][j] == 'X':
                pozicije_vatre.append((i, j))
            elif lavirint[i][j] == 'S':
                pozicija_steve = (i, j)
    
    vreme_vatre = bfs_vatra(pozicije_vatre, n, m, lavirint)
    
    vreme_steve = bfs_steva(pozicija_steve[0], pozicija_steve[1], n, m, lavirint, vreme_vatre)
    
    broj_sigurnih_polja = 0
    for i in range(n):
        for j in range(m):
            if lavirint[i][j] == '.' and vreme_steve[i][j] < vreme_vatre[i][j]:
                broj_sigurnih_polja += 1
    
    print(broj_sigurnih_polja)