#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

struct Tacka {
    ll x, y;
};

const int dx[] = {-1, 1, 0, 0};
const int dy[] = {0, 0, -1, 1};

bool jeValidno(ll x, ll y, ll n, ll m, const vector<string> &lv) {
    return x>=0 && x<n && y>=0 && y<m && lv[x][y] != '*';
}

ll pro(vector<string> &lv, Tacka steva, queue<Tacka> redVatre) {
    ll n=lv.size(), m=lv[0].size();
    queue<pair<Tacka, char>> red;
    vector<vector<ll>> posetioSteva(n, vector<ll>(m, INT_MAX));
    vector<vector<ll>> posetilaVatra(n, vector<ll>(m, INT_MAX));

    red.push({steva, 'S'});
    posetioSteva[steva.x][steva.y] = 0;

    while (!redVatre.empty()) {
        Tacka vatra = redVatre.front();
        redVatre.pop();
        red.push({vatra, 'X'});
        posetilaVatra[vatra.x][vatra.y] = 0;
    }

    ll sigurnaPolja=1;

    while (!red.empty()) {
        pair<Tacka, char> trenutni = red.front();
        red.pop();
        Tacka tacka=trenutni.first;
        char tip=trenutni.second;
        ll x=tacka.x, y=tacka.y;

        if (tip=='S' && lv[x][y]=='.' && posetioSteva[x][y]<posetilaVatra[x][y]) {
            sigurnaPolja++;
            lv[x][y]='S';
        }

        for (ll d=0; d<4; d++) {
            ll nx=x+dx[d], ny=y+dy[d];
            if (!jeValidno(nx, ny, n, m, lv)) continue;

            if (tip=='S') {
                if (posetioSteva[nx][ny]==INT_MAX && posetilaVatra[nx][ny]>posetioSteva[x][y]+1) {
                    posetioSteva[nx][ny]=posetioSteva[x][y]+1;
                    red.push({{nx, ny}, 'S'});
                }
            } else if (tip=='X') {
                if (posetilaVatra[nx][ny]==INT_MAX) {
                    posetilaVatra[nx][ny]=posetilaVatra[x][y]+1;
                    red.push({{nx, ny}, 'X'});
                }
            }
        }
    }
    for (ll i=0;i<n;i++) {
        for (ll j=0;j<m;j++) {
            if (lv[i][j]=='.') {
                lv[i][j]='X';
            }
        }
    }

    return sigurnaPolja;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0), cout.tie(0);

    ll n, m;
    cin >> n >> m;
    vector<string> lavirint(n);
    Tacka steva;
    queue<Tacka> redVatre;

    for (ll i=0;i<n;i++) {
        cin >> lavirint[i];
        for (ll j=0;j<m;j++) {
            if (lavirint[i][j]=='S') {
                steva={i, j};
            } else if (lavirint[i][j]=='X') {
                redVatre.push({i, j});
            }
        }
    }

    ll rez=pro(lavirint, steva, redVatre);

    cout << rez << endl;


    return 0;
}