#include <iostream>
#include <unordered_map>
#include <cmath>
#include <vector>
#include <map>
#include <algorithm>
#include <string>
#include <queue>
#include <fstream>
#include <random>
#include <stack>

using namespace std;


std::vector<std::vector<bool>> visited;
//std::vector<std::vector<char>> arr;
// age, pos
#define yx std::pair<int, int>
#define fire std::pair<int, yx>
#define fireQueue std::priority_queue<fire, std::vector<fire>, std::greater<fire>>

int res = 0;

void iterateFire(fireQueue& queue) {
    if (queue.empty()) return;
    int currAge = queue.top().first;
    while (!queue.empty() && queue.top().first == currAge) {
        yx pos = queue.top().second;
        int di[] = { -1, 0, 0, 1 };
        int dj[] = { 0, 1, -1, 0 };
        queue.pop();
        for (int k = 0; k < 4; k++) {
            int i = di[k] + pos.first;
            int j = dj[k] + pos.second;
            if (i >= 0 && i < visited.size() && j >= 0 && j < visited[0].size()) {
                if (!visited[i][j]) {
                    queue.push({ currAge + 1, {i, j} });
                    visited[i][j] = true;
                }
            }
        }
    }
}

void iterateMain(fireQueue& queue) {
    if (queue.empty()) return;
    int currAge = queue.top().first;
    while (!queue.empty() && queue.top().first == currAge) {
        yx pos = queue.top().second;
        int di[] = { -1, 0, 0, 1 };
        int dj[] = { 0, 1, -1, 0 };
        queue.pop();
        for (int k = 0; k < 4; k++) {
            int i = di[k] + pos.first;
            int j = dj[k] + pos.second;
            if (i >= 0 && i < visited.size() && j >= 0 && j < visited[0].size()) {
                if (!visited[i][j]) {
                    queue.push({ currAge + 1, {i, j} });
                    visited[i][j] = true;
                    res += 1;
                }
            }
        }
    }
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);

    /*int t;
    std::cin >> t;
    for (int iter = 0; iter < t; iter++) {
        long long l, r, k;
        std::cin >> l >> r >> k;
        
        long long p = r / k;
        long long res = (p - l + 1);
        if (res < 0) res = 0;
        std::cout << res << std::endl;
        
    }*/

    int n, m;
    std::cin >> n >> m;
    visited = std::vector<std::vector<bool>>(n, std::vector<bool>(m, false));
    //arr = std::vector<std::vector<char>>(n, std::vector<char>(m, '.'));
    
    fireQueue main;

    fireQueue fires;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            
            char k;
            std::cin >> k;
            if (k == 'S') {
                main.push({ 1, yx(i, j) });
                visited[i][j] = true;
            }
            else if (k == 'X') {
                fires.push({ 1, yx(i, j) });
                visited[i][j] = true;
            }
            else if (k == '*') {
                visited[i][j] = true;
            }
        }
    }
    
    while (!fires.empty() || !main.empty()) {
        iterateFire(fires);
        iterateMain(main);
    }

    std::cout << (res+1) << std::endl;

    return 0;
}