using System;
using System.Collections.Generic;

namespace Petlja
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string startInput = Console.ReadLine() ?? "0 0";
            int n = int.Parse(startInput.Split(" ")[0]);
            int m = int.Parse(startInput.Split(" ")[1]);

            char[,] field = new char[n, m];
            Queue<(int, int)> fireQueue = new Queue<(int, int)>();
            Queue<(int, int)> steveQueue = new Queue<(int, int)>();

            int[,] firePath = new int[n, m];
            int[,] stevePath = new int[n, m];

            for (int i = 0; i < n; i++)
            {
                string rowInput = Console.ReadLine() ?? "";
                for (int j = 0; j < m; j++)
                {
                    field[i, j] = rowInput[j];

                    firePath[i, j] = -1;
                    stevePath[i, j] = -1;

                    if (field[i, j] == 'X')
                    {
                        fireQueue.Enqueue((i, j));
                        firePath[i, j] = 0;
                    }
                    if (field[i, j] == 'S')
                    {
                        steveQueue.Enqueue((i, j));
                        stevePath[i, j] = 0;
                    }
                }
            }
    
            int[] dirX = { -1, 1, 0, 0 };
            int[] dirY = { 0, 0, -1, 1 };

            while (fireQueue.Count > 0)
            {
                var (x, y) = fireQueue.Dequeue();
                for (int i = 0; i < 4; i++)
                {
                    int nextX = x + dirX[i];
                    int nextY = y + dirY[i];

                    if (isValid(nextX, nextY, n, m) && field[nextX, nextY] == '.' && firePath[nextX, nextY] == -1)
                    {
                        firePath[nextX, nextY] = firePath[x, y] + 1;
                        fireQueue.Enqueue((nextX, nextY));
                    }
                }
            }

            while (steveQueue.Count > 0)
            {
                var (x, y) = steveQueue.Dequeue();
                for (int i = 0; i < 4; i++)
                {
                    int nextX = x + dirX[i];
                    int nextY = y + dirY[i];

                    if (isValid(nextX, nextY, n, m) && field[nextX, nextY] == '.' && stevePath[nextX, nextY] == -1)
                    {
                        if (firePath[nextX, nextY] == -1 || stevePath[x, y] + 1 < firePath[nextX, nextY])
                        {
                            stevePath[nextX, nextY] = stevePath[x, y] + 1;
                            steveQueue.Enqueue((nextX, nextY));
                        }
                    }
                }
            }

            int spaces = 0;
            for (int i = 0; i < n; i++)
            {
                for (int j = 0; j < m; j++)
                {
                    if (stevePath[i, j] != -1 && (firePath[i, j] == -1 || stevePath[i, j] < firePath[i, j]))
                    {
                        spaces++;
                    }
                }   
            }

            Console.WriteLine(spaces);
        }

        static bool isValid(int x, int y, int n, int m)
        {
            return x >= 0 && x < n && y >= 0 && y < m;
        }
    }
}