#include <bits/stdc++.h>
#define ll long long
using namespace std;

struct Interval
{
  ll start, end;
};

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  int N, Q;
  cin >> N >> Q;
  ll d[N], p[N];
  for (int i = 0; i < N; i++)
    cin >> d[i] >> p[i];

  vector<Interval> intervals;
  ll last_end = 0;

  for (int i = 0; i < N; i++)
  {
    ll start = max(last_end + 1, d[i]);
    ll end = start + p[i] - 1;
    last_end = end;

    if (!intervals.empty() && intervals.back().end >= start - 1)
      intervals.back().end = max(intervals.back().end, end);
    else
      intervals.push_back({start, end});
  }

  int M = intervals.size();

  ll pref[M];
  pref[0] = intervals[0].end - intervals[0].start + 1;
  for (int i = 1; i < M; i++)
  {
    pref[i] = pref[i - 1] + intervals[i].end - intervals[i].start + 1;
  }

  for (int i = 0; i < Q; i++)
  {
    ll k;
    cin >> k;

    ll interval = -1;
    int l = 0, r = M - 1;
    while (l <= r)
    {
      int mid = (l + r) / 2;
      if (intervals[mid].start <= k)
      {
        interval = mid;
        l = mid + 1;
      }
      else
      {
        r = mid - 1;
      }
    }

    if (interval == -1)
    {
      cout << "0\n";
      continue;
    }

    ll ans = pref[interval];
    if (intervals[interval].end > k)
      ans -= intervals[interval].end - k;

    cout << ans << "\n";
  }

  return 0;
}