from bisect import bisect_right

def plazma_pojedenih(bn, bp, nalazi, pitanja):
    def izracunaj_za_dan(dan_prestanka):
        if dan_prestanka < nalazi[0][0]:
            return 0           
        idx = bisect_right([n[0] for n in nalazi], dan_prestanka)
        rezultat = 0
        dostupno = 0
        prethodni_dan = 0        
        for i in range(idx):
            trenutni_dan = nalazi[i][0]
            razlika_dana = trenutni_dan - prethodni_dan
            if razlika_dana > 0:
                plazma_koriscena = min(dostupno, razlika_dana - 1)
                rezultat += plazma_koriscena
                dostupno -= plazma_koriscena            
            dostupno += nalazi[i][1]            
            if dostupno > 0:
                rezultat += 1
                dostupno -= 1               
            prethodni_dan = trenutni_dan        
        if idx > 0:
            preostali_dani = dan_prestanka - prethodni_dan
            if preostali_dani > 0:
                rezultat += min(dostupno, preostali_dani)                
        return rezultat   
    return [izracunaj_za_dan(dan_prestanka) for dan_prestanka in pitanja]

bn, bp = map(int, input().split())
nalazi = []
for _ in range(bn):
	dan, kolicina = map(int, input().split())
	nalazi.append((dan, kolicina))
pitanja = []
for _ in range(bp):
	dan_prestanka = int(input())
	pitanja.append(dan_prestanka)
rezultati = plazma_pojedenih(bn, bp, nalazi, pitanja)
for rezultat in rezultati:
	print(rezultat)