from collections import deque

def bfs_vatra(matrica, n, m):
    vatra_vreme = [[-1] * m for _ in range(n)]
    red = deque()
    
    for i in range(n):
        for j in range(m):
            if matrica[i][j] == 'X':
                vatra_vreme[i][j] = 0
                red.append((i, j))
    
    while red:
        x, y = red.popleft()
        for dx, dy in [(-1, 0), (1, 0), (0, -1), (0, 1)]:
            nx, ny = x + dx, y + dy
            if 0 <= nx < n and 0 <= ny < m and matrica[nx][ny] == '.' and vatra_vreme[nx][ny] == -1:
                vatra_vreme[nx][ny] = vatra_vreme[x][y] + 1
                red.append((nx, ny))
    
    return vatra_vreme

def bfs_steva(matrica, n, m, start_x, start_y):
    steva_vreme = [[-1] * m for _ in range(n)]
    red = deque([(start_x, start_y)])
    steva_vreme[start_x][start_y] = 0
    
    while red:
        x, y = red.popleft()
        for dx, dy in [(-1, 0), (1, 0), (0, -1), (0, 1)]:
            nx, ny = x + dx, y + dy
            if 0 <= nx < n and 0 <= ny < m and matrica[nx][ny] == '.' and steva_vreme[nx][ny] == -1:
                steva_vreme[nx][ny] = steva_vreme[x][y] + 1
                red.append((nx, ny))
    
    return steva_vreme

def resenje(n, m, matrica):
    start_x, start_y = -1, -1
    for i in range(n):
        for j in range(m):
            if matrica[i][j] == 'S':
                start_x, start_y = i, j
                break
        if start_x != -1:
            break
    
    vatra_vreme = bfs_vatra(matrica, n, m)
    steva_vreme = bfs_steva(matrica, n, m, start_x, start_y)
    
    sigurni = 1
    for i in range(n):
        for j in range(m):
            if matrica[i][j] == '.' and steva_vreme[i][j] != -1:
                if vatra_vreme[i][j] == -1 or steva_vreme[i][j] < vatra_vreme[i][j]:
                    sigurni += 1
    
    return sigurni

n, m = map(int, input().split())
matrica = [list(input().strip()) for _ in range(n)]

print(resenje(n, m, matrica))