import java.util.Scanner;

public class main {

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

       
        int n = sc.nextInt();
        int m = sc.nextInt();
        sc.nextLine(); 

        // lavirint
        char[][] maze = new char[n][m];
        int[][] fireTime = new int[n][m];  // breme kada vatra dolazi do svakog polja
        int[][] stevaTime = new int[n][m];  // vreme Steve da dode do svakog polja

        
        int stevaX = -1, stevaY = -1;

        for (int i = 0; i < n; i++) {
            String line = sc.nextLine();
            for (int j = 0; j < m; j++) {
                maze[i][j] = line.charAt(j);
                fireTime[i][j] = -1;  
                stevaTime[i][j] = -1; 

                // Pocetni položaj
                if (maze[i][j] == 'X') {
                    fireTime[i][j] = 0;  // V0 =  0
                }

               
                if (maze[i][j] == 'S') {
                    stevaX = i;
                    stevaY = j;
                    stevaTime[i][j] = 0; 
                }
            }
        }

        // Širenje vatre
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                if (fireTime[i][j] == 0) {
                    spreadFire(i, j, fireTime, maze);
                }
            }
        }

        // Pokreti
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                if (stevaTime[i][j] == 0) {
                    moveSteva(i, j, stevaTime, maze, fireTime);
                }
            }
        }


        int validCount = 0;
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                if (maze[i][j] == '.' && stevaTime[i][j] != -1 && (fireTime[i][j] == -1 || stevaTime[i][j] < fireTime[i][j])) {
                    validCount++;
                }
            }
        }

        
        System.out.println(validCount);

        sc.close();
    }

    
    public static void spreadFire(int x, int y, int[][] fireTime, char[][] maze) {
        // 4 smera
        int[] dx = {-1, 1, 0, 0};
        int[] dy = {0, 0, -1, 1};

        for (int i = 0; i < 4; i++) {
            int nx = x + dx[i];
            int ny = y + dy[i];

            if (nx >= 0 && ny >= 0 && nx < fireTime.length && ny < fireTime[0].length && maze[nx][ny] == '.' && fireTime[nx][ny] == -1) {
                fireTime[nx][ny] = fireTime[x][y] + 1;
                spreadFire(nx, ny, fireTime, maze);
            }
        }
    }

  
    public static void moveSteva(int x, int y, int[][] stevaTime, char[][] maze, int[][] fireTime) {
        
        int[] dx = {-1, 1, 0, 0};
        int[] dy = {0, 0, -1, 1};

        for (int i = 0; i < 4; i++) {
            int nx = x + dx[i];
            int ny = y + dy[i];

            if (nx >= 0 && ny >= 0 && nx < stevaTime.length && ny < stevaTime[0].length && maze[nx][ny] == '.' && stevaTime[nx][ny] == -1) {
                if (fireTime[nx][ny] == -1 || stevaTime[x][y] + 1 < fireTime[nx][ny]) {
                    stevaTime[nx][ny] = stevaTime[x][y] + 1;
                    moveSteva(nx, ny, stevaTime, maze, fireTime);
                }
            }
        }
    }
}