#include <iostream> 
#include <vector>
#include <algorithm>

using namespace std;
int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);
    int N, Q;
    cin >> N >> Q;

    vector<pair<long long, long long>> purchases(N); // {day, amount}
    vector<pair<long long, int>> sortedQueries(Q); // {day, index}
    vector<long long> res(Q);

    for (int i = 0; i < N; i++) {
        cin >> purchases[i].first >> purchases[i].second;
    }

    for (int i = 0; i < Q; i++) {
        cin >> sortedQueries[i].first;
        sortedQueries[i].second = i;
    }

    sort(sortedQueries.begin(), sortedQueries.end());

    vector<long long> prefixSum(N + 1, 0);
    for (int i = 0; i < N; i++) {
        prefixSum[i + 1] = prefixSum[i] + purchases[i].second;
    }

    long long consumed = 0, lastDay = 0, available = 0;
    int currentPurchase = 0;

    for (const auto& [k, idx] : sortedQueries) {
        while (currentPurchase < N && purchases[currentPurchase].first <= k) {
            available += purchases[currentPurchase].second;
            currentPurchase++;
        }
        
        long long daysToConsume = k - lastDay;
        long long packagesConsumed = min(available, daysToConsume);
        consumed += packagesConsumed;
        available -= packagesConsumed;  

        res[idx] = consumed;
        lastDay = k;
    }

    for (const long long& r : res) {
        cout << r << "\n";
    }

    return 0;
}