#include <iostream>
#include <queue>
#include <vector>
#include <algorithm>
using namespace std;

struct Polje{
    int x, y;
};

vector<vector<int>> bfs(Polje start, int n, int m, const vector<vector<char>>& mat){
    vector<vector<int>> dist(n, vector<int>(m, -1));  
    queue<Polje> q;
    q.push(start);
    dist[start.x][start.y] = 0;

    vector<Polje> dirs = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
    
    while (!q.empty()){
        Polje p = q.front();
        q.pop();
        for (auto& dir : dirs){
            int nx = p.x + dir.x;
            int ny = p.y + dir.y;
            if (nx >= 0 && nx < n && ny >= 0 && ny < m && mat[nx][ny] == '.' && dist[nx][ny] == -1){
                dist[nx][ny] = dist[p.x][p.y] + 1;
                q.push({nx, ny});
            }
        }
    }
    return dist;
}

void find_s_x(const vector<vector<char>>& mat, Polje& s_poz, vector<Polje>& x_poz){
    for (int i = 0; i < mat.size(); i++){
        for (int j = 0; j < mat[i].size(); j++){
            if (mat[i][j] == 'S'){
                s_poz = {i, j};
            } 
            else if (mat[i][j] == 'X'){
                x_poz.push_back({i, j});
            }
        }
    }
}

void broj_koraka(const vector<vector<char>>& mat, vector<vector<int>>& udodes, vector<vector<int>>& udodx){
    Polje s_poz;
    int n, m;
    n = mat.size();
    m = mat[0].size();
    vector<Polje> x_poz;
    find_s_x(mat, s_poz, x_poz);
    udodes = bfs(s_poz, n, m, mat);
    udodx = vector<vector<int>>(n, vector<int>(m, n * m));
    for (int i = 0; i < x_poz.size(); i++){
        vector<vector<int>> udodxk = bfs(x_poz[i], n, m, mat);
        for (int j = 0; j < n; j++){
            for (int l = 0; l < m; l++){
                if (udodxk[j][l] < udodx[j][l] && udodxk[j][l]!=-1){
                    udodx[j][l] = udodxk[j][l];
                }
            }
        }
    }
    for (auto& vek : udodx) {
        replace(vek.begin(), vek.end(), n*m, -1);
    }
}

int main()
{
    
    int n, m;
    cin >> n >> m;
    vector<vector<char>> mat(n, vector<char>(m));
    for (int i = 0; i < n; i++){
        for (int j = 0; j < m; j++){
            cin>>mat[i][j];
        }
    }
    vector<vector<int>> udodes, udodx;
    broj_koraka(mat, udodes, udodx);
    int b = 0;
    for (int i = 0; i < n; i++){
        for (int j = 0; j < m; j++){
            if ((udodes[i][j] < udodx[i][j] && udodes[i][j] != -1) || (udodes[i][j] != -1 && udodx[i][j] == -1)){
                b += 1;
            }
        }
    }
    cout << b;

    return 0;
}