#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define DIM 40
#define TRUE 1
#define FALSE 0

void ProveraUnosa(int *x, unsigned z);
void UnesiMatricu(char a[][DIM], int n, int m);
void StampajMatricu(char a[][DIM], int n, int m);
void GdeJeSteva();
void ProsiriVatru();
void PomeriStevu();
void Korak();
void SlobodnihMesta();


char a[DIM][DIM];
int n = 0, m = 0;
int Steva_i = 0, Steva_j = 0;
int Novo_i = 0, Novo_j = 0;
unsigned broj = 1;
int nastavi;

int main()
{
    printf("Unesite n (broj vrsta matrice [1, %d]): ", DIM);
    ProveraUnosa(&n, DIM);
    printf("Unesite m (broj kolona matrice [1, %d]): ", DIM);
    ProveraUnosa(&m, DIM);

    printf("Unesite matricu (karakteri: '.', 'S', 'X'):\n");
    UnesiMatricu(a, n, m);

    GdeJeSteva();

    do
    {
        Korak();
        SlobodnihMesta();
    } while (nastavi == TRUE);

    printf("Kraj igre nakon %d koraka.\n", broj - 1);

    return 0;
}

void ProveraUnosa(int *x, unsigned z)
{
    do
    {
        printf("Unos>> ");
        scanf("%d", x);
        if (*x < 1 || *x > z)
            printf("Doslo je do greske, pokusajte ponovo...\n");
    } while (*x < 1 || *x > z);
}

void UnesiMatricu(char a[][DIM], int n, int m)
{
    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            scanf(" %c", &a[i][j]);
        }
    }
}

void StampajMatricu(char a[][DIM], int n, int m)
{
    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            printf("%c", a[i][j]);
        }
        printf("\n");
    }
}

void GdeJeSteva()
{
    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            if (a[i][j] == 'S')
            {
                Steva_i = i;
                Steva_j = j;
                return;
            }
        }
    }
}

void ProsiriVatru()
{
    char temp[DIM][DIM];
    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            temp[i][j] = a[i][j];
        }
    }

    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            if (a[i][j] == 'X')
            {
                if (i > 0 && temp[i-1][j] == '.') temp[i-1][j] = 'X';
                if (i < n-1 && temp[i+1][j] == '.') temp[i+1][j] = 'X';
                if (j > 0 && temp[i][j-1] == '.') temp[i][j-1] = 'X';
                if (j < m-1 && temp[i][j+1] == '.') temp[i][j+1] = 'X';
            }
        }
    }

    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            a[i][j] = temp[i][j];
        }
    }
}

void PomeriStevu()
{
    int valid = FALSE;
    while (!valid)
    {
        printf("Unesite Stevine koordinate>> ");
        scanf("%d %d", &Novo_i, &Novo_j);

        if (abs(Novo_i - Steva_i) + abs(Novo_j - Steva_j) == 1 &&
            Novo_i >= 0 && Novo_i < n &&
            Novo_j >= 0 && Novo_j < m &&
            a[Novo_i][Novo_j] == '.')
        {
            valid = TRUE;
        }
        else
        {
            printf("Neispravan potez, pokusajte ponovo...\n");
        }
    }

    a[Steva_i][Steva_j] = '.';
    Steva_i = Novo_i;
    Steva_j = Novo_j;
    a[Steva_i][Steva_j] = 'S';
}

void Korak()
{
    printf("\nKorak %d\n\n", broj);
    StampajMatricu(a, n, m);
    PomeriStevu();
    ProsiriVatru();
    broj++;
}

void SlobodnihMesta()
{
    nastavi = FALSE;
    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            if (a[i][j] == '.')
            {
                nastavi = TRUE;
                return;
            }
        }
    }
}