#include <iostream>
#include <queue>
#include <vector>
#include <climits>
using namespace std;

const int pravci[4][2] = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

struct Pozicija {
    int x, y;
};


vector<vector<int>> bfs(const vector<Pozicija>& pocetne, const vector<string>& lavirint, int n, int m) {
    vector<vector<int>> udaljenost(n, vector<int>(m, -1));  
    queue<Pozicija> q;

  
    for (const auto& p : pocetne) {
        q.push(p);
        udaljenost[p.x][p.y] = 0;
    }

  
    while (!q.empty()) {
        Pozicija p = q.front();
        q.pop();
        for (int i = 0; i < 4; ++i) {
            int nx = p.x + pravci[i][0];
            int ny = p.y + pravci[i][1];
            if (nx >= 0 && nx < n && ny >= 0 && ny < m && lavirint[nx][ny] == '.' && udaljenost[nx][ny] == -1) {
                udaljenost[nx][ny] = udaljenost[p.x][p.y] + 1;
                q.push({nx, ny});
            }
        }
    }

    return udaljenost;
}

int main() {
    int n, m;
    cin >> n >> m;

    vector<string> lavirint(n);
    Pozicija stevaPozicija;
    vector<Pozicija> pozicijeVatre;


    for (int i = 0; i < n; ++i) {
        cin >> lavirint[i];
        for (int j = 0; j < m; ++j) {
            if (lavirint[i][j] == 'S') {
                stevaPozicija = {i, j};
            } else if (lavirint[i][j] == 'X') {
                pozicijeVatre.push_back({i, j});
            }
        }
    }

    vector<vector<int>> udaljenostVatre = bfs(pozicijeVatre, lavirint, n, m);
    vector<vector<int>> udaljenostSteve = bfs({stevaPozicija}, lavirint, n, m);

    int rezultat = 0;

    
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < m; ++j) {
            if (lavirint[i][j] == '.' || lavirint[i][j] == 'S') { 
                if (udaljenostSteve[i][j] != -1 && (udaljenostVatre[i][j] == -1 || udaljenostSteve[i][j] < udaljenostVatre[i][j])) {
                    rezultat++;
                }
            }
        }
    }

    cout << rezultat << endl;
    return 0;
}