using System;
using System.Collections.Generic;
using System.Runtime.CompilerServices;

class Zadatak
{
    static int[] dx = { -1, 1, 0, 0 };
    static int[] dy = { 0, 0, -1, 1 };
    static void Main()
    {
        string[] s = Console.ReadLine().Split();
        int N = int.Parse(s[0]);
        int M = int.Parse(s[1]);
        char[,] t = new char[N, M];
        int startx = -1;
        int starty = -1;
        int bezbedno = 1;
        Queue<Tuple<int, int>> vatra = new Queue<Tuple<int, int>>();
        Queue<Tuple<int, int>> steva = new Queue<Tuple<int, int>>();
        for (int i = 0; i < N; i++)
        {
            var red = Console.ReadLine();
            for (int j = 0; j < M; j++)
            {
                t[i, j] = red[j];
                if (t[i, j] == 'S')
                {
                    startx = i;
                    starty = j;
                }
                else if (red[j] == 'X')
                {
                    vatra.Enqueue(Tuple.Create(i, j));
                }
            }
        }

        int[,] vatravreme = new int[N, M];
        int[,] stevavreme = new int[N, M];

        for (int i = 0; i < N; i++)
        {
            for (int j = 0; j < M; j++)
            {
                vatravreme[i, j] = -1;
                stevavreme[i, j] = -1;
            }
        }
        while (vatra.Count > 0)
        {
            var cell = vatra.Dequeue();
            int x = cell.Item1;
            int y = cell.Item2;
            if (vatravreme[x, y] == -1)
            {
                vatravreme[x, y] = 0;
            }

            for (int d = 0; d < 4; d++)
            {
                int nx = x + dx[d], ny = y + dy[d];
                if (nx >= 0 && ny >= 0 && nx < N && ny < M && t[nx, ny] == '.' && vatravreme[nx, ny] == -1)
                {
                    vatravreme[nx, ny] = vatravreme[x, y] + 1;
                    vatra.Enqueue(Tuple.Create(nx, ny));
                }
            }
        }

        steva.Enqueue(Tuple.Create(startx, starty));
        stevavreme[startx, starty] = 0;

        while (steva.Count > 0)
        {
            var cell = steva.Dequeue();
            int x = cell.Item1, y = cell.Item2;

            for (int d = 0; d < 4; d++)
            {
                int nx = x + dx[d], ny = y + dy[d];
                if (nx >= 0 && ny >= 0 && nx < N && ny < M && t[nx, ny] == '.' && stevavreme[nx, ny] == -1)
                {
                    if (vatravreme[nx, ny] == -1 || stevavreme[x, y] + 1 < vatravreme[nx, ny])
                    {
                        stevavreme[nx, ny] = stevavreme[x, y] + 1;
                        steva.Enqueue(Tuple.Create(nx, ny));
                    }
                }
            }
        }
        for (int i = 0; i < N; i++)
        {
            for (int j = 0; j < M; j++)
            {
                if (t[i, j] == '.' && stevavreme[i, j] != -1 && (vatravreme[i, j] == -1 || stevavreme[i, j] < vatravreme[i, j]))
                {
                    bezbedno++;
                }
            }
        }
        Console.WriteLine(bezbedno);
    }
}