using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        // ????????? ????????? ?????????
        string[] dimensions = Console.ReadLine().Split();
        int N = int.Parse(dimensions[0]);
        int M = int.Parse(dimensions[1]);

        char[,] labyrinth = new char[N, M];
        Queue<(int, int)> fireQueue = new Queue<(int, int)>();
        (int, int) stevaStart = (-1, -1);

        // ????????? ????????? ? ??????????????? ???????? ????? ? ?????
        for (int i = 0; i < N; i++)
        {
            string line = Console.ReadLine();
            for (int j = 0; j < M; j++)
            {
                labyrinth[i, j] = line[j];
                if (line[j] == 'X')
                {
                    fireQueue.Enqueue((i, j)); // ????? ????? ? ???
                }
                else if (line[j] == 'S')
                {
                    stevaStart = (i, j); // ????? ??????? ????????
                }
            }
        }

        // ??????? ?? ????? ??????? ????? ? ?????
        int[,] fireTime = new int[N, M];
        int[,] stevaTime = new int[N, M];
        for (int i = 0; i < N; i++)
        {
            for (int j = 0; j < M; j++)
            {
                fireTime[i, j] = int.MaxValue; // ?????? ?? ????? ???? ??????? ??? ????
                stevaTime[i, j] = int.MaxValue; // ?????? ?? ????? ???? ??????? ??? ????
            }
        }

        // ?????? ????? ???????
        int[] dx = { -1, 1, 0, 0 };
        int[] dy = { 0, 0, -1, 1 };

        // BFS ?? ?????
        while (fireQueue.Count > 0)
        {
            var (x, y) = fireQueue.Dequeue();
            for (int dir = 0; dir < 4; dir++)
            {
                int nx = x + dx[dir];
                int ny = y + dy[dir];
                if (nx >= 0 && nx < N && ny >= 0 && ny < M &&
                    labyrinth[nx, ny] == '.' && fireTime[nx, ny] == int.MaxValue)
                {
                    fireTime[nx, ny] = fireTime[x, y] + 1;
                    fireQueue.Enqueue((nx, ny));
                }
            }
        }

        // BFS ?? ??????? ?????
        Queue<(int, int)> stevaQueue = new Queue<(int, int)>();
        stevaQueue.Enqueue(stevaStart);
        stevaTime[stevaStart.Item1, stevaStart.Item2] = 0;

        while (stevaQueue.Count > 0)
        {
            var (x, y) = stevaQueue.Dequeue();
            for (int dir = 0; dir < 4; dir++)
            {
                int nx = x + dx[dir];
                int ny = y + dy[dir];
                if (nx >= 0 && nx < N && ny >= 0 && ny < M &&
                    labyrinth[nx, ny] == '.' && stevaTime[nx, ny] == int.MaxValue)
                {
                    stevaTime[nx, ny] = stevaTime[x, y] + 1;
                    stevaQueue.Enqueue((nx, ny));
                }
            }
        }

        // ???????????? ???? ?? ?????? ????? ???? ??????
        int safeFields = 0;
        for (int i = 0; i < N; i++)
        {
            for (int j = 0; j < M; j++)
            {
                // ??? ????? ???? ????? ??? ?????
                if (stevaTime[i, j] < fireTime[i, j])
                {
                    safeFields++;
                }
            }
        }

        // ????? ?????????
        Console.WriteLine(safeFields);
    }
}