import bisect

N, Q = map(int, input().split())
days = []
packs = []
for _ in range(N):
    di, pi = map(int, input().split())
    days.append(di)
    packs.append(pi)

prefix_sum = [0] * N
prefix_sum[0] = packs[0]
for i in range(1, N):
    prefix_sum[i] = prefix_sum[i - 1] + packs[i]

queries = []
for _ in range(Q):
    queries.append(int(input()))

for k in queries:
    idx = bisect.bisect_right(days, k) - 1
    if idx == -1:
        print(0)
    else:
        print(prefix_sum[idx])