using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp2
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string[] str = Console.ReadLine().Split();
            int n = int.Parse(str[0]);
            int m = int.Parse(str[1]);
            char[,] a = new char[n, m];

            int[,] vatraSirenje = new int[n, m];
            int[,] stevaSirenje = new int[n, m];
            Queue<(int, int)> vRed = new Queue<(int, int)>();
            Queue<(int, int)> sRed = new Queue<(int, int)>();

            for (int i = 0; i < n; i++)
            {
                string line = Console.ReadLine();
                for (int j = 0; j < m; j++)
                {
                    a[i, j] = line[j];
                    vatraSirenje[i, j] = int.MaxValue;
                    stevaSirenje[i, j] = int.MaxValue;

                    if (a[i, j] == 'X') vRed.Enqueue((i, j));
                    if (a[i, j] == 'S')
                    {
                        sRed.Enqueue((i, j));
                        stevaSirenje[i, j] = 0;
                    }
                }
            }

            foreach ((int fx, int fy) in vRed)
            {
                vatraSirenje[fx, fy] = 0; 
            }

            (int, int)[] d = { (-1, 0), (1, 0), (0, -1), (0, 1) };

            while (vRed.Count > 0 || sRed.Count > 0)
            {
                int vBr = vRed.Count;
                for (int f = 0; f < vBr; f++)
                {
                    (int fx, int fy) = vRed.Dequeue();
                    foreach ((int dx, int dy) in d)
                    {
                        int nx = fx + dx, ny = fy + dy;
                        if (nx >= 0 && ny >= 0 && nx < n && ny < m && a[nx, ny] != '*' && vatraSirenje[nx, ny] == int.MaxValue)
                        {
                            vatraSirenje[nx, ny] = vatraSirenje[fx, fy] + 1;
                            vRed.Enqueue((nx, ny));
                        }
                    }
                }

                int sBr = sRed.Count;
                for (int s = 0; s < sBr; s++)
                {
                    (int sx, int sy) = sRed.Dequeue();
                    foreach ((int dx, int dy) in d)
                    {
                        int nx = sx + dx, ny = sy + dy;
                        if (nx >= 0 && ny >= 0 && nx < n && ny < m && a[nx, ny] != '*' && stevaSirenje[nx, ny] == int.MaxValue)
                        {
                            if (stevaSirenje[sx, sy] + 1 < vatraSirenje[nx, ny])
                            {
                                stevaSirenje[nx, ny] = stevaSirenje[sx, sy] + 1;
                                sRed.Enqueue((nx, ny));
                            }
                        }
                    }
                }
            }

            int rez = 0;
            for (int i = 0; i < n; i++)
            {
                for (int j = 0; j < m; j++)
                {
                    if ((a[i, j] == '.' || a[i, j] == 'S') && stevaSirenje[i, j] < vatraSirenje[i, j])
                    {
                        rez++;
                    }
                }
            }

            Console.WriteLine(rez);
        }
    }
}