#define _CRT_DISABLE_PERFCRIT_LOCKS
#define ll long long
#include <iostream>
#include <algorithm>
#include <cmath>
#include <vector>
#include <queue>
using namespace std;

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);

	int x, y, res = 1, brojZidova = 0;
	cin >> x >> y;
	vector<vector<char>> maze;
	queue<pair<int, int>> fireQ;
	queue<pair<int, int>> stevaQ;

	for (int i = 0; i < x; i++)
	{
		vector<char> row;
		for (int j = 0; j < y; j++)
		{
			char t;
			cin >> t;
			if (t == 'X') fireQ.push({ i, j });
			if (t == 'S') stevaQ.push({ i, j });
			if (t == '*') brojZidova++;
			row.push_back(t);
		}
		maze.push_back(row);
	}

	if (fireQ.empty())
	{
		res = (x * y) - brojZidova;
		std::cout << res;
		return 0;
	}

	while (!stevaQ.empty())
	{
		pair<int, int> vat;
		pair<int, int> stev = stevaQ.front();
		bool stevaMoved = false;

		if (!fireQ.empty())
		{
			vat = fireQ.front();
			// Sever
			if (vat.first - 1 >= 0 && maze[vat.first - 1][vat.second] == '.')
			{
				fireQ.push({ vat.first - 1, vat.second });
				maze[vat.first - 1][vat.second] = 'X';
			}

			// Jug
			if (vat.first + 1 < x && maze[vat.first + 1][vat.second] == '.')
			{
				fireQ.push({ vat.first + 1, vat.second });
				maze[vat.first + 1][vat.second] = 'X';
			}

			// Zapad
			if (vat.second - 1 >= 0 && maze[vat.first][vat.second - 1] == '.')
			{
				fireQ.push({ vat.first, vat.second - 1 });
				maze[vat.first][vat.second - 1] = 'X';
			}

			// Istok
			if (vat.second + 1 < y && maze[vat.first][vat.second + 1] == '.')
			{
				fireQ.push({ vat.first, vat.second + 1 });
				maze[vat.first][vat.second + 1] = 'X';
			}
			fireQ.pop();
		}


		// Sever (steva)
		if (stev.first - 1 >= 0 && maze[stev.first - 1][stev.second] == '.')
		{
			stevaQ.push({ stev.first - 1, stev.second });
			maze[stev.first - 1][stev.second] = 'S';
			res++;
			stevaMoved = true;
		}
		// Zapad (steva)
		if (stev.second - 1 >= 0 && maze[stev.first][stev.second - 1] == '.')
		{
			stevaQ.push({ stev.first, stev.second - 1 });
			if (!stevaMoved)
			{
				maze[stev.first][stev.second - 1] = 'S';
				res++;
				stevaMoved = true;
			}
		}
		// Jug (steva)
		if (stev.first + 1 < x && maze[stev.first + 1][stev.second] == '.')
		{
			stevaQ.push({ stev.first + 1, stev.second });
			if (!stevaMoved)
			{
				maze[stev.first + 1][stev.second] = 'S';
				res++;
				stevaMoved = true;
			}
		}
		// Istok (steva)
		if (stev.second + 1 < y && maze[stev.first][stev.second + 1] == '.')
		{
			stevaQ.push({ stev.first, stev.second + 1 });
			if (!stevaMoved)
			{
				maze[stev.first][stev.second + 1] = 'S';
				res++;
				stevaMoved = true;
			}
		}
		stevaQ.pop();
	}

	std::cout << res;
}