using System;

namespace _2_Plazma
{
    internal class Program
    {
        struct Kupovina : IComparable<Kupovina>  //Struktura mozda moze biti jednostavnije od dva niza ili matrice ako nista zbog preglednosti
        {
            public Kupovina(UInt64 dan, UInt64 kutija_keksa)//Kostruktor se moze pokazati koristan za vreme unosa
            {
                this.dan = dan;
                this.kutija_keksa = kutija_keksa;
                this.kutija_ukupno_na_taj_dan = 0;
            }

            public UInt64 dan;
            public UInt64 kutija_keksa;
            public UInt64 kutija_ukupno_na_taj_dan;


            public int CompareTo(Kupovina other)    //Razredni secam se ovog pakla :)
            {
                return this.dan.CompareTo(other.dan); // Uporedujemo prema danu
            }
        }

        static void Main(string[] args)
        {
            string[] temp;
            int broj_kupovina, broj_upita, poslednji_dan;
            UInt64 pojedeno_kutija_keksa, ukupna_dostupna_plazma, prvi_dostupan_dan, poslednji_dostupni_dan, broj_dana_od_prvog_dostupnog_dana; //Hvala bogu za intellisense
            Kupovina[] kupovina;
            UInt64[] upit;

            // 1. Ulaz
            temp = Console.ReadLine().Split();
            broj_kupovina = int.Parse(temp[0]);
            broj_upita = int.Parse(temp[1]);

            kupovina = new Kupovina[broj_kupovina];
            upit = new UInt64[broj_upita];

            //2. unosim sve kupovine
            for (int i = 0; i < broj_kupovina; i++)
            {
                temp = Console.ReadLine().Split();

                kupovina[i] = new Kupovina(UInt64.Parse(temp[0]), UInt64.Parse(temp[1]));

                if (i == 0)
                {
                    kupovina[i].kutija_ukupno_na_taj_dan = kupovina[i].kutija_keksa;
                }
                else
                {
                    kupovina[i].kutija_ukupno_na_taj_dan = kupovina[i - 1].kutija_ukupno_na_taj_dan + kupovina[i].kutija_keksa;
                }
            }

            //3. unosim sve upite
            for (int i = 0; i < broj_upita; i++)
            {
                upit[i] = UInt64.Parse(Console.ReadLine());
            }

            // 4. ispitujem...
            for (int i = 0; i < broj_upita; i++)
            {
                poslednji_dostupni_dan = upit[i];
                ukupna_dostupna_plazma = 0;
                prvi_dostupan_dan = kupovina[0].dan;

                poslednji_dan = Array.BinarySearch(kupovina, new Kupovina(poslednji_dostupni_dan, 0)); //zbog ovoga mora IComparable da se radi (moglo je i peske ali ovo lakse)
                                                                                                       //morao bi i za array.sort ali sam pitao i uvek se unosi sotrirano

                if (poslednji_dan < 0)
                {
                    poslednji_dan = ~poslednji_dan - 1; //Array.BinarySearch vrati negativan broj ukoliko element ne postoji pa ovo to resava
                }

                if (poslednji_dan >= 0)
                {
                    ukupna_dostupna_plazma = kupovina[poslednji_dan].kutija_ukupno_na_taj_dan;
                }

                if (poslednji_dostupni_dan >= prvi_dostupan_dan)
                {
                    broj_dana_od_prvog_dostupnog_dana = poslednji_dostupni_dan - prvi_dostupan_dan + 1;
                }
                else
                {
                    broj_dana_od_prvog_dostupnog_dana = 0;
                }

                pojedeno_kutija_keksa = Math.Min(ukupna_dostupna_plazma, broj_dana_od_prvog_dostupnog_dana);

                Console.WriteLine(pojedeno_kutija_keksa);
                //Verovatno negde gubim na vremenu ili memoriji ali nema vise kafe da se to resava 
                //Jutros od 7 programiram robota ovo je stvarno najbolje sto mogu za sada
            }
        }
    }
}