using System;

class Program
{
    static void Main()
    {
        string[] temp;
        string temp2;
        char[,] matrica; //Ovo moram ovako zato sto se char unosi ...X..S
        int N, M, bezbedno, novo_x, novo_y;
        int[,] matrica_vatre, matrica_steve;
        Queue<(int, int)> red_za_vatru = new Queue<(int, int)>(); //redovi su jako kul, rade kao FIFO bufferi
        Queue<(int, int)> red_za_stevu = new Queue<(int, int)>();
        (int, int) pocetna_pozicija_steve = (-1, -1);   //Ovo je par kordinata koje predstavljaju stevinu pocetnu poziciju

        bezbedno = 0;
        int[] korak_x = { -1, 1, 0, 0 };
        int[] korak_y = { 0, 0, -1, 1 };

        //Unosim dimenzije matrice
        temp = Console.ReadLine().Split();
        N = int.Parse(temp[0]);
        M = int.Parse(temp[1]);

        //Inicijalizacija matrica
        matrica = new char[N, M];
        matrica_vatre = new int[N, M];
        matrica_steve = new int[N, M];
        
        //For za unos matrice
        for (int i = 0; i < N; i++)
        {
            temp2 = Console.ReadLine();

            //Ovde rasparcam jednu liniju i ubelezim kordinate steve i vatre
            for (int j = 0; j < M; j++)
            {
                matrica[i, j] = temp2[j];   

                matrica_vatre[i, j] = int.MaxValue;
                matrica_steve[i, j] = int.MaxValue; 

                //Ubelezi kordinate steve i vatre kada se njihovi karakteri unesu
                if (matrica[i, j] == 'X')
                {
                    red_za_vatru.Enqueue((i, j));
                    matrica_vatre[i, j] = 0;
                }
                else if (matrica[i, j] == 'S')
                {
                    pocetna_pozicija_steve = (i, j);
                    matrica_steve[i, j] = 0;
                }
            }
        }

        red_za_stevu.Enqueue(pocetna_pozicija_steve);   //Kada smo nasli pocetnu poziciju steve dodajemo je u red

        //Ovo smo ja mislim radili kod vulikica kada je pustao na projektoru
        //Ali secam se ovoga iz one knjige algoritmi i strukture podataka
        //Odatle mi i idelja da koristim redove

        //radim BFS za vatru
        while (red_za_vatru.Count > 0)
        {
            var (staro_x, staro_y) = red_za_vatru.Dequeue();
            //Proverim za svaki smer kretanja
            for (int i = 0; i < 4; i++)
            {
                //izracunam nove kordinate
                novo_x = staro_x + korak_x[i];
                novo_y = staro_y + korak_y[i];

                //Proverim jesu li kordinate ok i da li je to mesro slobodno u matricama
                if (((novo_x >= 0 && novo_x < N) && (novo_y >= 0 && novo_y < M)) && ((matrica[novo_x, novo_y] == '.') && (matrica_vatre[novo_x, novo_y] == int.MaxValue)))
                {
                    matrica_vatre[novo_x, novo_y] = matrica_vatre[staro_x, staro_y] + 1;
                    red_za_vatru.Enqueue((novo_x, novo_y));
                }
            }
        }

        //radim BFS za stevu
        while (red_za_stevu.Count > 0)
        {
            var (staro_x, staro_y) = red_za_stevu.Dequeue();
            //Proverim za svaki smer kretanja
            for (int i = 0; i < 4; i++)
            {
                //izracunam nove kordinate
                novo_x = staro_x + korak_x[i];
                novo_y = staro_y + korak_y[i];

                //Proverim jesu li kordinate ok i da li je to mesro slobodno u matricama
                if (((novo_x >= 0 && novo_x < N) && (novo_y >= 0 && novo_y < M)) && ((matrica[novo_x, novo_y] == '.') && (matrica_steve[novo_x, novo_y] == int.MaxValue)))
                {
                    matrica_steve[novo_x, novo_y] = matrica_steve[staro_x, staro_y] + 1;
                    red_za_stevu.Enqueue((novo_x, novo_y));
                }
            }
        }

        // Brojim bezbedna polja
        for (int i = 0; i < N; i++)
        {
            for (int j = 0; j < M; j++)
            {
                if (matrica_steve[i, j] < matrica_vatre[i, j]) // Sreva stiže pre vatre
                {
                    bezbedno++;
                }
            }
        }

        Console.WriteLine(bezbedno);

        //Ovo je bilo mnogo lakse nego sto sam ocekivao 
        //Veliki Pozdrav za Stevu Golubovica naseg rukovodioca sa Elekronike iz petnice (steva ima elitru)
    }
}