using System;
using System.Collections.Generic;

class Program
{
    static void Main(string[] args)
    {
        var input = Console.ReadLine().Split();
        int N = int.Parse(input[0]); 
        int Q = int.Parse(input[1]); 

        var kupovine = new List<(long dan, long pakovanja)>();
        for (int i = 0; i < N; i++)
        {
            var line = Console.ReadLine().Split();
            long di = long.Parse(line[0]);
            long pi = long.Parse(line[1]);
            kupovine.Add((di, pi));
        }
        var upiti = new List<long>();
        for (int i = 0; i < Q; i++)
        {
            upiti.Add(long.Parse(Console.ReadLine()));
        }
        kupovine.Sort((a, b) => a.dan.CompareTo(b.dan));
        upiti.Sort();
        var sumaKupovina = new long[N];
        sumaKupovina[0] = kupovine[0].pakovanja;
        for (int i = 1; i < N; i++)
        {
            sumaKupovina[i] = sumaKupovina[i - 1] + kupovine[i].pakovanja;
        }
        var rezultati = new long[Q];
        long trenutnaZaliha = 0;
        long trenutniDan = 1;
        int indeksKupovine = 0;

        foreach (var kj in upiti)
        {
            while (trenutniDan <= kj)
            {
                if (indeksKupovine < N && trenutniDan == kupovine[indeksKupovine].dan)
                {
                    trenutnaZaliha += kupovine[indeksKupovine].pakovanja;
                    indeksKupovine++;
                }
                if (trenutnaZaliha > 0)
                {
                    trenutnaZaliha--;
                }

                trenutniDan++;
            }
            long ukupnoPojedeno = (indeksKupovine > 0 ? sumaKupovina[indeksKupovine - 1] : 0) - trenutnaZaliha;
            rezultati[Array.IndexOf(upiti.ToArray(), kj)] = ukupnoPojedeno;
        }
        foreach (var rezultat in rezultati)
        {
            Console.WriteLine(rezultat);
        }
    }
}