using System;

class Program
{
    static void Main()
    {
        
        int N = 2; // broj puta otac kupuje Plazmu
        int Q = 2; // broj pitanja

        // dani kada kupujemo plazmu
        var kupljenoPoDanu = new (int dan, int kolicina)[N];
        kupljenoPoDanu[0] = (1, 2); // 1. parametar je dan, 2. plazma (1. dan, 2 plazme)
        kupljenoPoDanu[1] = (5, 10); 

        
        var pitanja = new int[Q]; 
        pitanja[0] = 7; // ako prestane posle 7.
        pitanja[1] = 3; // ako prestane posle 3.

        // kada je plazma dostupna
        int[] dnevnaPlazma = new int[300001]; // ne vise od 300 000 dana
        foreach (var kupovina in kupljenoPoDanu)
        {
            dnevnaPlazma[kupovina.dan] = kupovina.kolicina; // koliko je kupljeno
        }

        // 2. Prodi kroz sva pitanja
        foreach (var pitanje in pitanja)
        {
            int cerkaPojela = 0; // pojedeno od strane cerke
            int rezervePlazme = 0; // rezerve, tj. ukupno od danas i proslih dana

            // kroz sve dane do dana gde je pitanje (idemo od 1. do 7. ako je pitanje 7 ili od 1. do 3. ako je 3)
            for (int i = 1; i <= pitanje; i++)
            {
                // dodaj rezervi
                rezervePlazme += dnevnaPlazma[i];

                // jede ako je dostupno
                if (rezervePlazme > 0)
                {
                    cerkaPojela++;
                    rezervePlazme--; 
                }
            }

            // rezultat
            Console.WriteLine(cerkaPojela);
        }
    }
}