using System;
using System.Collections.Generic;
namespace pozarSteva;
class Program
{
    static void Main(string[] args)
    {
        
        int n = 5, m = 5;

        
        char[,] map = new char[,]
        {
            { '.', '.', '.', '.', '.' },
            { '.', '*', '.', 'X', '.' },
            { '.', '*', 'S', '.', '.' },
            { '.', '*', '.', '*', '.' },
            { '.', '.', '.', '.', '.' }
        };

        
        int[] dx = { -1, 1, 0, 0 };
        int[] dy = { 0, 0, -1, 1 };

        
        int[,] vremeVatre = new int[n, m];
        Queue<(int, int)> vatraQueue = new Queue<(int, int)>();

        
        for (int i = 0; i < n; i++)
        {
            for (int j = 0; j < m; j++)
            {
                // vreme beskonacno
                vremeVatre[i, j] = int.MaxValue;
            }
        }

        // pocetne pozicije
        int startX = -1, startY = -1;
        for (int i = 0; i < n; i++)
        {
            for (int j = 0; j < m; j++)
            {
                if (map[i, j] == 'X')
                {
                    vatraQueue.Enqueue((i, j));
                    vremeVatre[i, j] = 0; 
                }
                else if (map[i, j] == 'S')
                {
                    startX = i;
                    startY = j;
                }
            }
        }

        // sirenje vatre
        while (vatraQueue.Count > 0)
        {
            var (x, y) = vatraQueue.Dequeue();
            for (int i = 0; i < 4; i++)
            {
                int nx = x + dx[i], ny = y + dy[i];
                if (nx >= 0 && nx < n && ny >= 0 && ny < m && map[nx, ny] == '.' && vremeVatre[nx, ny] == int.MaxValue)
                {
                    vremeVatre[nx, ny] = vremeVatre[x, y] + 1;
                    vatraQueue.Enqueue((nx, ny));
                }
            }
        }

        // sirenje steve
        int[,] vremeSteve = new int[n, m];
        
        for (int i = 0; i < n; i++)
        {
            for (int j = 0; j < m; j++)
            {
                vremeSteve[i, j] = int.MaxValue;
            }
        }

        // vreme 0
        vremeSteve[startX, startY] = 0;
        Queue<(int, int)> stevaQueue = new Queue<(int, int)>();
        stevaQueue.Enqueue((startX, startY));

        while (stevaQueue.Count > 0)
        {
            var (x, y) = stevaQueue.Dequeue();
            for (int i = 0; i < 4; i++)
            {
                int nx = x + dx[i], ny = y + dy[i];
                if (nx >= 0 && nx < n && ny >= 0 && ny < m && map[nx, ny] == '.' && vremeSteve[nx, ny] == int.MaxValue && vremeSteve[x, y] + 1 < vremeVatre[nx, ny])
                {
                    vremeSteve[nx, ny] = vremeSteve[x, y] + 1;
                    stevaQueue.Enqueue((nx, ny));
                }
            }
        }

        // da li steva moze stici pre vatre
        int mogucaPolja = 0;
        for (int i = 0; i < n; i++)
        {
            for (int j = 0; j < m; j++)
            {
                if (map[i, j] == '.' && vremeSteve[i, j] < vremeVatre[i, j])
                {
                    mogucaPolja++;
                }
            }
        }

        // rezultat
        Console.WriteLine(mogucaPolja);
    }
}