import java.util.*;

public class Main {

    static class Par {
        int x, y;

        Par(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static void main(String[] args) {
        Scanner skener = new Scanner(System.in);

        int n = skener.nextInt();
        int m = skener.nextInt();
        skener.nextLine();

        char[][] lavirint = new char[n][m];
        int[][] vremeVatre = new int[n][m];
        int[][] vremeSteve = new int[n][m];
        Queue<Par> redVatre = new LinkedList<>();
        Queue<Par> redSteve = new LinkedList<>();

        Par stevaStart = null;

        for (int i = 0; i < n; i++) {
            String linija = skener.nextLine();
            for (int j = 0; j < m; j++) {
                lavirint[i][j] = linija.charAt(j);
                vremeVatre[i][j] = Integer.MAX_VALUE; 
                vremeSteve[i][j] = Integer.MAX_VALUE; 
                if (lavirint[i][j] == 'X') {
                    redVatre.add(new Par(i, j));
                    vremeVatre[i][j] = 0;
                } else if (lavirint[i][j] == 'S') {
                    stevaStart = new Par(i, j);
                    vremeSteve[i][j] = 0;
                }
            }
        }

        
        int[] dx = {-1, 1, 0, 0};
        int[] dy = {0, 0, -1, 1};

       //bfs
        while (!redVatre.isEmpty()) {
            Par trenutni = redVatre.poll();
            for (int d = 0; d < 4; d++) {
                int nx = trenutni.x + dx[d];
                int ny = trenutni.y + dy[d];

                if (nx >= 0 && ny >= 0 && nx < n && ny < m &&
                        lavirint[nx][ny] == '.' &&
                        vremeVatre[nx][ny] > vremeVatre[trenutni.x][trenutni.y] + 1) {
                    vremeVatre[nx][ny] = vremeVatre[trenutni.x][trenutni.y] + 1;
                    redVatre.add(new Par(nx, ny));
                }
            }
        }

       
        redSteve.add(stevaStart);
        int dostupnaPolja = 0;

        while (!redSteve.isEmpty()) {
            Par trenutni = redSteve.poll();
            for (int d = 0; d < 4; d++) {
                int nx = trenutni.x + dx[d];
                int ny = trenutni.y + dy[d];

                if (nx >= 0 && ny >= 0 && nx < n && ny < m &&
                        lavirint[nx][ny] == '.' &&
                        vremeSteve[nx][ny] > vremeSteve[trenutni.x][trenutni.y] + 1 &&
                        vremeSteve[trenutni.x][trenutni.y] + 1 < vremeVatre[nx][ny]) {
                    vremeSteve[nx][ny] = vremeSteve[trenutni.x][trenutni.y] + 1;
                    redSteve.add(new Par(nx, ny));
                }
            }
        }

        
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                if (vremeSteve[i][j] < vremeVatre[i][j]) {
                    dostupnaPolja++;
                }
            }
        }

        System.out.println(dostupnaPolja);
    }
}