#include <iostream>
#include <vector>
#include <queue>
#include <tuple>
#include <climits>

using namespace std;

int resiLavirint(int n, int m, vector<string>& lavirint) {
    pair<int, int> steva;
    vector<pair<int, int>> pozicijeVatre;

    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < m; ++j) {
            if (lavirint[i][j] == 'S') {
                steva = {i, j};
            } else if (lavirint[i][j] == 'X') {
                pozicijeVatre.push_back({i, j});
            }
        }
    }

    vector<pair<int, int>> pravci = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
    vector<vector<int>> vremeVatre(n, vector<int>(m, INT_MAX));
    queue<tuple<int, int, int>> red;

    for (const auto& pozicija : pozicijeVatre) {
        red.push({pozicija.first, pozicija.second, 0});
        vremeVatre[pozicija.first][pozicija.second] = 0;
    }

    while (!red.empty()) {
        auto [x, y, t] = red.front();
        red.pop();
        for (const auto& [dx, dy] : pravci) {
            int nx = x + dx, ny = y + dy;
            if (nx >= 0 && nx < n && ny >= 0 && ny < m &&
                lavirint[nx][ny] == '.' && vremeVatre[nx][ny] > t + 1) {
                vremeVatre[nx][ny] = t + 1;
                red.push({nx, ny, t + 1});
            }
        }
    }

    vector<vector<int>> vremeSteve(n, vector<int>(m, INT_MAX));
    red.push({steva.first, steva.second, 0});
    vremeSteve[steva.first][steva.second] = 0;

    int dostupnaPolja = 0;

    while (!red.empty()) {
        auto [x, y, t] = red.front();
        red.pop();
        if (t < vremeVatre[x][y]) {
            ++dostupnaPolja;
        }
        for (const auto& [dx, dy] : pravci) {
            int nx = x + dx, ny = y + dy;
            if (nx >= 0 && nx < n && ny >= 0 && ny < m &&
                lavirint[nx][ny] == '.' && vremeSteve[nx][ny] > t + 1) {
                if (t + 1 < vremeVatre[nx][ny]) {
                    vremeSteve[nx][ny] = t + 1;
                    red.push({nx, ny, t + 1});
                }
            }
        }
    }

    return dostupnaPolja;
}

int main() {
    int n, m;
    cin >> n >> m;

    vector<string> lavirint(n);
    for (int i = 0; i < n; ++i) {
        cin >> lavirint[i];
    }

    int rezultat = resiLavirint(n, m, lavirint);
    cout << rezultat << endl;

    return 0;
}