using System;

namespace pozar {
    
class POZ {
    
    static bool searchInMatrix(char[,] arr, char x) {
        int m = arr.GetLength(0), n = arr.GetLength(1);

        for (int i = 0; i < m; i++) {
            for (int j = 0; j < n; j++) {
                if (arr[i, j] == x)
                    return true;
            }
        }
        return false;
    }
    
    public static void Main() {
        char Steva = 'S';
        char Zid = '*';
        char Polje = '.';
        char Vatra = 'X';

        string[] data1 = Console.ReadLine().Split(" ");
        int N = int.Parse(data1[0]);
        int M = int.Parse(data1[1]);
        char[,] H = new char[N, M];

        for (int i = 0; i < N; i++) {
            string row = Console.ReadLine();
            for (int j = 0; j < M; j++) {
                H[i, j] = row[j]; 
            }
        }

        int p = -1, q = -1;
        int brojpolja = 1;
        int brojpoteza = 1;
        int brojvatre = 0;

        for (int i = 0; i < N; i++) {
            for (int j = 0; j < M; j++) {
                if (H[i, j] == Steva) {
                    p = i;
                    q = j;
                }
                if (H[i, j] == Polje) {
                    brojpolja++;
                }
                if(H[i, j] == Vatra){
                    brojvatre++;
                }
            }
        }
        
        int[][] directions = new int[][] {
            new int[] { -1, 0 },
            new int[] { 1, 0 },
            new int[] { 0, -1 },
            new int[] { 0, 1 }
        };
        bool moved = true;

        while (moved) {
            moved = false;
            for (int d = 0; d < directions.Length; d++) {
                int newX = p + directions[d][0];
                int newY = q + directions[d][1];
                if (IsInBounds(newX, newY, N, M) && H[newX, newY] == Polje) {
                    H[newX, newY] = Steva;
                    brojpoteza++; 
                    p = newX;
                    q = newY;
                    moved = true; // Mark that a move was made
                    break; // Exiting as we only want to make one move per turn
                }
            }

            // Move fire
            for (int i = 0; i < N; i++) {
                for (int j = 0; j < M; j++) {
                  if(brojvatre == 0){
                      brojpoteza = brojpolja;
                      break;
                  }
                  else{
                    if (H[i, j] == Vatra) {
                        for (int d = 0; d < directions.Length; d++) {
                            int fireX = i + directions[d][0];
                            int fireY = j + directions[d][1];
                            if (IsInBounds(fireX, fireY, N, M) && H[fireX, fireY] == Polje) {
                                H[fireX, fireY] = Vatra; // Mark new position of fire
                            }
                        }
                    }
                  }
                }
            }
        }

        Console.WriteLine(brojpoteza);
    }

    // Helper function to check bounds
    private static bool IsInBounds(int x, int y, int N, int M) {
        return x >= 0 && x < N && y >= 0 && y < M;
    }
}
}