#include <bits/stdc++.h>

using namespace std;

const int dx[4] = {-1, 1, 0, 0};
const int dy[4] = {0, 0, -1, 1};

vector<vector<int>> bfs(int n, int m, const vector<string>& lavirint, const vector<pair<int, int>>& pocetak) {
    
    vector<vector<int>> udaljenost(n, vector<int>(m, INT_MAX));
    queue<pair<int, int>> red;

    for (pair<int, int> p : pocetak) {
        udaljenost[p.first][p.second] = 0;
        red.push(p);
    }

    while (!red.empty()) {
        int x = red.front().first;
        int y = red.front().second;
        red.pop();
        
        for (int i = 0; i < 4; i++) {
            int xp = x + dx[i];
            int yp = y + dy[i];

            if (xp >= 0 && xp < n && yp >= 0 && yp < m && lavirint[xp][yp] == '.' && udaljenost[xp][yp] == INT_MAX) {
                udaljenost[xp][yp] = udaljenost[x][y] + 1;
                red.push({xp, yp});
            }
        }
    }

    return udaljenost;
}



int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
    int n, m;
    cin >> n >> m;
    vector<string> lavirint(n);

    for (int i = 0; i < n; i++) {
        cin >> lavirint[i];
    }

    pair<int, int> S;
    vector<pair<int, int>> X;

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            if (lavirint[i][j] == 'S') {
                S = {i, j};
            }
            else if (lavirint[i][j] == 'X') {
                X.push_back({i, j});
            }
        }
    }

    vector<vector<int>> vatra = bfs(n, m, lavirint, X);

    vector<vector<int>> steva = bfs(n, m, lavirint, {S});


    int s = 0;
    
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            if (lavirint[i][j] == '.' && steva[i][j] < vatra[i][j]) {
                s++;
            }
        }
    }
    
    cout << s + 1 << endl;

    return 0;
}