using System;

class Program
{
    static void Main()
    {
        string[] firstLine = Console.ReadLine().Split();
        long numPurchases = long.Parse(firstLine[0]);
        long numQueries = long.Parse(firstLine[1]);

        long[] purchaseDays = new long[numPurchases];
        long[] packetsBought = new long[numPurchases];

        for (long i = 0; i < numPurchases; i++)
        {
            string[] purchaseInfo = Console.ReadLine().Split();
            purchaseDays[i] = long.Parse(purchaseInfo[0]);
            packetsBought[i] = long.Parse(purchaseInfo[1]);
        }

        long[] queries = new long[numQueries];
        for (long j = 0; j < numQueries; j++)
        {
            queries[j] = long.Parse(Console.ReadLine());
        }

        long currentPackets = 0;
        long totalEaten = 0;
        long currentPurchaseIndex = 0;
        long maxQueryDay = queries[numQueries - 1] > purchaseDays[numPurchases - 1] ? queries[numQueries - 1] : purchaseDays[numPurchases - 1];

        long[] results = new long[numQueries];
        long queryIndex = 0;

        for (long day = 1; day <= maxQueryDay; day++)
        {
            if (currentPurchaseIndex < numPurchases && purchaseDays[currentPurchaseIndex] == day)
            {
                currentPackets += packetsBought[currentPurchaseIndex];
                currentPurchaseIndex++;
            }

            if (currentPackets > 0)
            {
                totalEaten++;
                currentPackets--;
            }

            while (queryIndex < numQueries && queries[queryIndex] == day)
            {
                results[queryIndex] = totalEaten;
                queryIndex++;
            }
        }

        for (long i = 0; i < numQueries; i++)
        {
            if (queries[i] > maxQueryDay)
            {
                Console.WriteLine(totalEaten);
            }
            else
            {
                Console.WriteLine(results[i]);
            }
        }
    }
}