using System;
using System.Collections.Generic;
namespace Pozar
{
    internal class Program
    {
        static void UnosPodataka(out int n, out int m, out char[,] lavirint, out Queue<(int, int)> steva, out Queue<(int, int)> vatra)
        {
            int[] ulaz = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
            n = ulaz[0];
            m = ulaz[1];
            lavirint = new char[n, m];
            vatra = new Queue<(int, int)> ();
            steva = new Queue<(int, int)> ();
            for (int i = 0; i < n; i++)
            {
                string linija = Console.ReadLine();
                for (int j = 0; j < m; j++)
                {
                    lavirint[i, j] = linija[j];
                    if (lavirint[i, j] == 'X')
                    {
                        vatra.Enqueue((i, j));
                        continue;
                    }
                    else if (lavirint[i, j] == 'S')
                    {
                        steva.Enqueue((i, j));
                    }
                }
            }
        }

        static int[,] PopunjavanjeMatrice(int n, int m)
        {
            int[,] a = new int[n, m];
            for (int i = 0; i < n; i++)
            {
                for (int j = 0; j < m; j++)
                {
                    a[i, j] = int.MaxValue;
                }
            }
            return a;
        }

        static void Sirenje(Queue<(int, int)> stvar, int[,] vreme, char[,] lavirint, int n, int m)
        {
            int[] dx = { 0, 0, 1, -1 };
            int[] dy = { 1, -1, 0, 0 };
            while (stvar.Count > 0)
            {
                var (x, y) = stvar.Dequeue();
                for (int i = 0; i < 4; i++)
                {
                    int tx = x + dx[i];
                    int ty = y + dy[i];
                    if (tx >= 0 && ty >= 0 && tx < n && ty < m && lavirint[tx, ty] == '.' && vreme[tx, ty] == int.MaxValue)
                    {
                        vreme[tx, ty] = vreme[x, y] + 1;
                        stvar.Enqueue((tx, ty));
                    }
                }
            }
        }

        static int BrojanjePolja(int n, int m, int[,] vremeVatre, int[,] stevaPotrebnoVreme, char[,] lavirint)
        {
            int brPolja = 1;
            for (int i = 0; i < n; i++)
            {
                for(int j = 0; j < m; j++)
                {
                    if (lavirint[i, j] == '.' && stevaPotrebnoVreme[i,j] < vremeVatre[i, j]) brPolja++;
                }
            }
            return brPolja;
        }

        static void Main(string[] args)
        {
            UnosPodataka(out int n, out int m, out char[,] lavirint, out Queue<(int, int)> steva, out Queue<(int, int)> vatra);
            int[,] vremeVatre = PopunjavanjeMatrice(n, m);
            int[,] stevaPotrebnoVreme = PopunjavanjeMatrice(n, m);
            Sirenje(vatra, vremeVatre, lavirint, n, m);
            Sirenje(steva, stevaPotrebnoVreme, lavirint, n, m);
            Console.WriteLine(BrojanjePolja(n, m, vremeVatre, stevaPotrebnoVreme, lavirint));
        }
    }
}