#include <cstdint>
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <memory>
#include <string>
#include <sstream>

std::unique_ptr<int32_t[]> int_arr_input(const int32_t vals_count) {
  std::string input; // Input
  std::getline(std::cin, input);

  // Parsing
  std::unique_ptr<int32_t[]> out = std::make_unique<int32_t[]>(vals_count);
  std::istringstream iss(input);
  int32_t num; 
  for (int i = 0; i < vals_count; i++) {
    iss >> num;
    out[i] = num;
  }
  return out;
}


int main() {
  int32_t stalactiteArrLen, guyH;
  std::cin >> stalactiteArrLen >> guyH;
  std::cin.ignore();
  auto stalactites = int_arr_input(stalactiteArrLen);

  // We have stalactites, stalactiteArrLen, guyH
  // To find: stIdx
  for (int i = 0; i < stalactiteArrLen; i++) {
    if (stalactites[i] < guyH) {
      std::cout << i << '\n'; 
      return 0;
    }
  }
  //
  std::cout << -1 << '\n'; 
  return 0;
}