#include <cstdint>
#include <iostream>
#include <map>
#include <memory>


typedef struct{
  uint64_t day;
  uint64_t amount;
} DayAmountPair;

int main() {
  uint32_t kdeBoughtTimes; 
  uint32_t questionsCount;
  std::cin >> kdeBoughtTimes >> questionsCount;

  auto dayAmoutMap = std::map<uint64_t, uint64_t>();
  for (int i = 0; i < kdeBoughtTimes; i++) {
    uint64_t day, amount;
    std::cin >> day >> amount;
    dayAmoutMap.insert({day, amount});
  }

  auto questions = std::make_unique<uint64_t[]>(questionsCount);
  for (int i = 0; i < questionsCount; i++) {
    std::cin >> questions[i];
  }

  // dayAmountPairs with len kdeBoughtTimes
  // questions with len questionsCount
  // questions[i] > questions[i-1]
  // each day 1 kde plasma got eaten (if there are some)

  for (int i = 0; i < questionsCount; i++) {
    uint64_t dayToStop = questions[i];
    uint32_t supliedDaysCounter = 0;
    uint64_t kdeCounter = 0; 
    uint64_t eatenCounter = 0; 

    for (uint64_t day = 1; day <= dayToStop; day++) {
      if (supliedDaysCounter == kdeBoughtTimes) {
        // now the quesiton what left more:
        // plasmas or days before the stop?
        if (dayToStop-day+1 > kdeCounter) {
          eatenCounter += kdeCounter;
        } else {
          eatenCounter += dayToStop-day+1;
        }
        break;
      }
      int32_t supplied = dayAmoutMap[day];
      if (supplied != 0) {
        kdeCounter += supplied-1;
        supliedDaysCounter++;
        eatenCounter++;
      } else {
        if (kdeCounter > 0) {
          kdeCounter--;
          eatenCounter++;
        }
      }
    }
    std::cout << eatenCounter << '\n';
  }

  return 0;
}