from collections import deque

def fire_bfs(fire_grid, N, M):
    fire_time = [[-1] * M for _ in range(N)]
    queue = deque()

    for i in range(N):
        for j in range(M):
            if fire_grid[i][j] == 'X':
                fire_time[i][j] = 0
                queue.append((i, j))

    directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]
    while queue:
        x, y = queue.popleft()
        current_time = fire_time[x][y]

        for dx, dy in directions:
            nx, ny = x + dx, y + dy
            if 0 <= nx < N and 0 <= ny < M and fire_time[nx][ny] == -1 and fire_grid[nx][ny] == '.':
                fire_time[nx][ny] = current_time + 1
                queue.append((nx, ny))

    return fire_time

def steva_bfs(steve_start, fire_time, N, M):
    steve_time = [[-1] * M for _ in range(N)]
    queue = deque([steve_start])
    steve_time[steve_start[0]][steve_start[1]] = 0

    directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]
    while queue:
        x, y = queue.popleft()
        current_time = steve_time[x][y]

        for dx, dy in directions:
            nx, ny = x + dx, y + dy
            if 0 <= nx < N and 0 <= ny < M and steve_time[nx][ny] == -1:
                if fire_time[nx][ny] == -1 or fire_time[nx][ny] > current_time + 1:
                    steve_time[nx][ny] = current_time + 1
                    queue.append((nx, ny))

    return steve_time


def count_safe_cells(maze, N, M):
    steve_start = None
    fire_grid = []

    for i in range(N):
        row = list(maze[i])
        fire_grid.append(row)
        if 'S' in row:
            steve_start = (i, row.index('S'))

    fire_time = fire_bfs(fire_grid, N, M)

    steve_time = steva_bfs(steve_start, fire_time, N, M)

    safe_cells_count = 0
    for i in range(N):
        for j in range(M):
            if maze[i][j] == '.' and steve_time[i][j] != -1:
                if fire_time[i][j] == -1 or steve_time[i][j] <= fire_time[i][j]:
                    safe_cells_count += 1

    return safe_cells_count

N, M = map(int, input().split())
maze = [input().strip() for _ in range(N)]
print(count_safe_cells(maze, N, M) + 1)