#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
#include <tuple>
#define int long long
using namespace std;
bool proveri(int x, int y, int n, int m, const vector<vector<char>>& matrica) {
    return x >= 0 && x < n && y >= 0 && y < m && matrica[x][y] != '*';
}

signed main() {
    int n, m;
    cin >> n >> m;
    vector<vector<char>> matrica(n, vector<char>(m));
    vector<vector<int>> vatraDuzina(n, vector<int>(m, INT_MAX)); 
    vector<vector<int>> stevaDuzina(n, vector<int>(m, INT_MAX));
    queue<pair<int, int>> q1, q2;
    int startX, startY;
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < m; ++j) {
            cin >> matrica[i][j];
            if (matrica[i][j] == 'X') {
                q1.push({ i, j });
                vatraDuzina[i][j] = 0;
            }
            else if (matrica[i][j] == 'S') {
                startX = i;
                startY = j;
                q2.push({ i, j });
                stevaDuzina[i][j] = 0;
            }
        }
    }
    while (!q1.empty()) {
        int x = q1.front().first;
        int y = q1.front().second;
        int duzina = vatraDuzina[x][y];
        q1.pop();
        if (proveri(x - 1, y, n, m, matrica) && vatraDuzina[x - 1][y] == INT_MAX) {
            vatraDuzina[x - 1][y] = duzina + 1;
            q1.push({ x - 1, y });
        }
        if (proveri(x + 1, y, n, m, matrica) && vatraDuzina[x + 1][y] == INT_MAX) {
            vatraDuzina[x + 1][y] = duzina + 1;
            q1.push({ x + 1, y });
        }
        if (proveri(x, y - 1, n, m, matrica) && vatraDuzina[x][y - 1] == INT_MAX) {
            vatraDuzina[x][y - 1] = duzina + 1;
            q1.push({ x, y - 1 });
        }
        if (proveri(x, y + 1, n, m, matrica) && vatraDuzina[x][y + 1] == INT_MAX) {
            vatraDuzina[x][y + 1] = duzina + 1;
            q1.push({ x, y + 1 });
        }
    }
    while (!q2.empty()) {
        int x = q2.front().first;
        int y = q2.front().second;
        int duzina = stevaDuzina[x][y];
        q2.pop();
        if (proveri(x - 1, y, n, m, matrica) && stevaDuzina[x - 1][y] == INT_MAX && duzina + 1 < vatraDuzina[x - 1][y]) {
            stevaDuzina[x - 1][y] = duzina + 1;
            q2.push({ x - 1, y });
        }
        if (proveri(x + 1, y, n, m, matrica) && stevaDuzina[x + 1][y] == INT_MAX && duzina + 1 < vatraDuzina[x + 1][y]) {
            stevaDuzina[x + 1][y] = duzina + 1;
            q2.push({ x + 1, y });
        }
        if (proveri(x, y - 1, n, m, matrica) && stevaDuzina[x][y - 1] == INT_MAX && duzina + 1 < vatraDuzina[x][y - 1]) {
            stevaDuzina[x][y - 1] = duzina + 1;
            q2.push({ x, y - 1 });
        }
        if (proveri(x, y + 1, n, m, matrica) && stevaDuzina[x][y + 1] == INT_MAX && duzina + 1 < vatraDuzina[x][y + 1]) {
            stevaDuzina[x][y + 1] = duzina + 1;
            q2.push({ x, y + 1 });
        }
    }
    int r = 0;
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < m; ++j) {
            if (stevaDuzina[i][j] < vatraDuzina[i][j]) {
                r++;
            }
        }
    }

    cout << r;
}