#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

struct q
{
    ll dan;
    int tip;
    int idx;
    q(ll dan, int tip, int idx) : dan(dan), tip(tip), idx(idx) {}
};

bool Compareq(const q &a, const q &b)
{
    if (a.dan != b.dan)
        return a.dan < b.dan;
    return a.tip < b.tip;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int N, Q;
    cin >> N >> Q;
    vector<q> qs;
    ll poslednji_dan_plazme = 0;

    for (int i = 0; i < N; i++)
    {
        ll d, p;
        cin >> d >> p;

        ll pocetni_dan = max(d, poslednji_dan_plazme + 1);
        ll poslednji_dan = pocetni_dan + p - 1;
        poslednji_dan_plazme = poslednji_dan;

        qs.emplace_back(pocetni_dan, 0, -1);
        qs.emplace_back(poslednji_dan + 1, 1, -1);
    }

    for (int i = 0; i < Q; i++)
    {
        ll k;
        cin >> k;
        qs.emplace_back(k, 2, i);
    }

    sort(qs.begin(), qs.end(), Compareq);

    ll trenutno_plazme = 0;
    ll ukupno_plazme = 0;
    ll krajnji_dan = 0;

    vector<ll> ogdovori(Q);

    for (const auto& qq : qs)
    {
        ll dan = qq.dan;
        int tip = qq.tip;
        int idx = qq.idx;

        ll razlika_dana = dan - krajnji_dan;
        ukupno_plazme += trenutno_plazme * razlika_dana;
        krajnji_dan = dan;

        if (tip == 0)
        {
            trenutno_plazme += 1;
        }
        else if (tip == 1)
        {
            trenutno_plazme -= 1;
        }
        else if (tip == 2)
        {
            ll total = ukupno_plazme;

            if (trenutno_plazme > 0)
            {
                total += trenutno_plazme;
            }
            ogdovori[idx] = total;
        }
    }

    for (ll odg : ogdovori)
    {
        cout << odg << '\n';
    }

    return 0;
}