#include <bits/stdc++.h>
using namespace std;
using ll = long long;
using ld = long double;
const int N = 2e5 + 20;

vector<pair<int,int>> dir = {{-1, 0},{1, 0},{0, -1},{0, 1}};

bool isValid(int x,int y, int n , int m, vector<vector<char>>& a,vector<vector<bool>>& visited){
    return x >= 0 && x < n && y >= 0 && y < m && a[x][y] != '*' && !visited[x][y];
}

void bfs(vector<vector<char>>& a,int n, int m, vector<pair<int,int>> s, vector<vector<int>>& d){
    vector<vector<bool>> visited(n,vector<bool>(m,false));
    queue<pair<int,int>> q;
    for(auto& start : s){
        q.push(start);
        visited[start.first][start.second]=true;
        d[start.first][start.second]=0;
    }

    while(!q.empty()){

        pair<int,int> cur = q.front();
        q.pop();

        for(pair<int,int> dr : dir){
            int nx = cur.first + dr.first;
            int ny = cur.second + dr.second;

            if(isValid(nx,ny,n,m,a,visited)){
                visited[nx][ny]=true;
                d[nx][ny]=d[cur.first][cur.second]+1;
                q.push({nx,ny});
            }

        }

    }

}

void solve()
{
    ll n,m;
    cin >> n >> m;
    vector<vector<char>> a(n,vector<char>(m));


    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            cin >> a[i][j];
        }
    }

    vector<pair<int, int>> s;
    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            if(a[i][j] == 'S'){
                s.push_back({i,j});
                break;
            }
        }
        if(!s.empty())break;
    }

    vector<vector<int>> d(n,vector<int>(m,1e8));
    bfs(a,n,m,s,d);
    /*for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            cout << d[i][j] << " ";
        }
        cout << "\n";
    }*/
    vector<vector<int>> dvat(n,vector<int>(m,1e8));

    s.clear();

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            if (a[i][j] == 'X') {
                s.push_back({i, j});
            }
        }
    }
    if(!s.empty())bfs(a,n,m,s,dvat);

    /*for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            cout << dvat[i][j] << " ";
        }
        cout << "\n";
    }*/

    int cnt = 0;
    for(int i = 0; i  < n; i++){
        for(int j = 0; j < m; j++){
            if(d[i][j] < dvat[i][j]){
                cnt++;
            }
        }
    }
    cout << cnt << "\n";
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t;
    t = 1;
    //cin >> t;
    while(t--){
        solve();
    }

}