#include <stdio.h>
#include <stdlib.h>


typedef struct {
    long long day;
    long long packages;
} Purchase;


int compare(const void *a, const void *b) {
    Purchase *pa = (Purchase *)a;
    Purchase *pb = (Purchase *)b;
    if (pa->day < pb->day) return -1;
    if (pa->day > pb->day) return 1;
    return 0;
}


int binary_search(Purchase purchases[], int n, long long query) {
    int low = 0, high = n - 1;
    int res = -1;
    while (low <= high) {
        int mid = (low + high) / 2;
        if (purchases[mid].day <= query) {
            res = mid;
            low = mid + 1;
        } else {
            high = mid - 1;
        }
    }
    return res;
}

int main() {
    int N, Q;
    
    scanf("%d %d", &N, &Q);

    
    Purchase purchases[N];
    
    
    for (int i = 0; i < N; i++) {
        scanf("%lld %lld", &purchases[i].day, &purchases[i].packages);
    }
    
   
    long long queries[Q];
    for (int i = 0; i < Q; i++) {
        scanf("%lld", &queries[i]);
    }
    
    
    qsort(purchases, N, sizeof(Purchase), compare);
    
    
    long long prefix_sum[N];
    prefix_sum[0] = purchases[0].packages;
    for (int i = 1; i < N; i++) {
        prefix_sum[i] = prefix_sum[i - 1] + purchases[i].packages;
    }

    
    for (int i = 0; i < Q; i++) {
        long long k = queries[i];
        
        
        int idx = binary_search(purchases, N, k);
        
        
        if (idx == -1) {
            printf("0\n");
        } else {
            
            printf("%lld\n", prefix_sum[idx]);
        }
    }

    return 0;
}