#include <iostream>
#include <queue>
#include <vector>

using namespace std;


int pomeraj_x[] = {-1, 1, 0, 0};
int pomeraj_y[] = {0, 0, -1, 1};

int N, M;
vector<vector<char>> lavirint;
vector<vector<int>> distanca_vatre, distanca_s;

bool da_li_je_validno(int x, int y) {
    return x >= 0 && x < N && y >= 0 && y < M && lavirint[x][y] != '*';
}

void bfs_vatra(queue<pair<int, int>>& red_vatre) {
    while (!red_vatre.empty()) {
        auto [x, y] = red_vatre.front();
        red_vatre.pop();
        
        for (int i = 0; i < 4; ++i) {
            int nx = x + pomeraj_x[i], ny = y + pomeraj_y[i];
            if (da_li_je_validno(nx, ny) && distanca_vatre[nx][ny] == -1) {
                distanca_vatre[nx][ny] = distanca_vatre[x][y] + 1;
                red_vatre.push({nx, ny});
            }
        }
    }
}

void bfs_s(pair<int, int> pocetna_pozicija) {
    queue<pair<int, int>> red_s;
    red_s.push(pocetna_pozicija);
    distanca_s[pocetna_pozicija.first][pocetna_pozicija.second] = 0;

    while (!red_s.empty()) {
        auto [x, y] = red_s.front();
        red_s.pop();

        for (int i = 0; i < 4; ++i) {
            int nx = x + pomeraj_x[i], ny = y + pomeraj_y[i];
            if (da_li_je_validno(nx, ny) && distanca_s[nx][ny] == -1) {
                if (distanca_vatre[nx][ny] == -1 || distanca_s[x][y] + 1 < distanca_vatre[nx][ny]) {
                    distanca_s[nx][ny] = distanca_s[x][y] + 1;
                    red_s.push({nx, ny});
                }
            }
        }
    }
}

int main() {
    cin >> N >> M;
    lavirint.resize(N, vector<char>(M));
    distanca_vatre.resize(N, vector<int>(M, -1)); 
    distanca_s.resize(N, vector<int>(M, -1)); 

    pair<int, int> pocetna_pozicija_s; 
    queue<pair<int, int>> red_vatre;

    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            cin >> lavirint[i][j];
            if (lavirint[i][j] == 'X') {
                distanca_vatre[i][j] = 0;  
                red_vatre.push({i, j});
            } else if (lavirint[i][j] == 'S') {
                pocetna_pozicija_s = {i, j};
            }
        }
    }

    bfs_vatra(red_vatre);

    bfs_s(pocetna_pozicija_s);

    int rezultat = 1;
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
        
            if (lavirint[i][j] == '.' && distanca_s[i][j] != -1 && 
                (distanca_vatre[i][j] == -1 || distanca_s[i][j] < distanca_vatre[i][j])) {
                rezultat++;
            }
        }
    }
    cout << rezultat << endl;
    return 0;
}