#include <iostream>
#include <queue>
#include <vector>
#include <utility>

using namespace std;

const int sorIrany[] = {-1, 1, 0, 0};
const int oszlopIrany[] = {0, 0, -1, 1};

int main() {
    int N, M;
    cin >> N >> M;

    vector<string> labirintus(N);

    for (int i = 0; i < N; i++)
    {

        cin >> labirintus[i];
    }


    queue<pair<int, int>> tuzSor, sanyiSor;

    vector<vector<int>> tuzIdo(N, vector<int>(M, -1));

    vector<vector<int>> sanyiIdo(N, vector<int>(M, -1));

    int sanyiKezdoSor, sanyiKezdoOszlop;
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < M; j++) {
            if (labirintus[i][j] == 'X') {
                tuzSor.push({i, j});
                tuzIdo[i][j] = 0;
            } else if (labirintus[i][j] == 'S') {
                sanyiKezdoSor = i;
                sanyiKezdoOszlop = j;
                sanyiSor.push({i, j});
                sanyiIdo[i][j] = 0;
            }
        }
    }




    while (!tuzSor.empty()) {

        auto [sor, oszlop] = tuzSor.front();
        tuzSor.pop();

        for (int k = 0; k < 4; k++) {

            int ujSor = sor + sorIrany[k];
            int ujOszlop = oszlop + oszlopIrany[k];

            if (ujSor >= 0 && ujSor < N && ujOszlop >= 0 && ujOszlop < M && labirintus[ujSor][ujOszlop] == '.' && tuzIdo[ujSor][ujOszlop] == -1) {
                tuzIdo[ujSor][ujOszlop] = tuzIdo[sor][oszlop] + 1;
                tuzSor.push({ujSor, ujOszlop});
            }
        }
    }


    int biztonsagosMezok = 0;
    while (!sanyiSor.empty()) {
        auto [sor, oszlop] = sanyiSor.front();
        sanyiSor.pop();

        if (tuzIdo[sor][oszlop] == -1 || sanyiIdo[sor][oszlop] < tuzIdo[sor][oszlop]) {
            biztonsagosMezok++;
        }

        for (int k = 0; k < 4; k++) {
            int ujSor = sor + sorIrany[k];
            int ujOszlop = oszlop + oszlopIrany[k];

            if (ujSor >= 0 && ujSor < N && ujOszlop >= 0 && ujOszlop < M && labirintus[ujSor][ujOszlop] == '.' && sanyiIdo[ujSor][ujOszlop] == -1) {
                sanyiIdo[ujSor][ujOszlop] = sanyiIdo[sor][oszlop] + 1;
                sanyiSor.push({ujSor, ujOszlop});
            }
        }
    }

    cout << biztonsagosMezok;

    return 0;
}