import java.util.Scanner;

public class Mavenproject4 {

    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);

        int N = in.nextInt();  // broj puta kad je otac nasao Plazmu
        int Q = in.nextInt();  // broj pitanja

        // Lista za unos dana i broja pakovanja
        int[] dani = new int[N];
        int[] pakovanja = new int[N];
        
        // Unos podataka o danima i pakovanjima
        for (int i = 0; i < N; i++) {
            dani[i] = in.nextInt();  // dan kada je otac nasao Plazmu
            pakovanja[i] = in.nextInt();  // broj pakovanja na tom danu
        }

        // Lista za unos pitanja
        int[] pitanja = new int[Q];
        for (int i = 0; i < Q; i++) {
            pitanja[i] = in.nextInt();  // dan kada ce cerka prestati da jede Plazmu
        }

        // Rezultati odgovora na pitanja
        int[] odgovori = new int[Q];
        
        // Prebrojavanje pakovanja kesa do svakog dana
        int[] ukupnoPakovanja = new int[N];
        ukupnoPakovanja[0] = pakovanja[0];
        for (int i = 1; i < N; i++) {
            ukupnoPakovanja[i] = ukupnoPakovanja[i - 1] + pakovanja[i];
        }

        // Odgovori na svako pitanje
        for (int q = 0; q < Q; q++) {
            int k = pitanja[q];
            int levo = 0;
            int desno = N - 1;
            
            // Binarnom pretrgom nalazimo prvi dan kada je dan veci od k
            while (levo <= desno) {
                int srednje = (levo + desno) / 2;
                if (dani[srednje] <= k) {
                    levo = srednje + 1;
                } else {
                    desno = srednje - 1;
                }
            }

            // Ako je levo == 0, to znaci da ca je prestala da jede pre nego što je ikada kupio Plazmu
            if (levo == 0) {
                odgovori[q] = 0;
            } else {
                odgovori[q] = ukupnoPakovanja[levo - 1];
            }
        }

        // Ispis rezultata za svako pitanje
        for (int odgovor : odgovori) {
            System.out.println(odgovor);
        }
    }
}