#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;


struct Purchase {
    long long day;
    long long count;
};

int main() {
    int N, Q;
    cin >> N >> Q;

    
    vector<Purchase> purchases(N);
    
    
    for (int i = 0; i < N; i++) {
        cin >> purchases[i].day >> purchases[i].count;
    }

   
    vector<long long> queries(Q);
    for (int i = 0; i < Q; i++) {
        cin >> queries[i];
    }

    
    vector<pair<long long, int>> sorted_queries(Q);
    for (int i = 0; i < Q; i++) {
        sorted_queries[i] = {queries[i], i};
    }
    sort(sorted_queries.begin(), sorted_queries.end());

   
    vector<long long> results(Q, 0);

    
    long long total_cakes = 0; 
    int purchase_index = 0;   

    
    for (int i = 0; i < Q; i++) {
        long long day = sorted_queries[i].first;
        int query_idx = sorted_queries[i].second;

        
        while (purchase_index < N && purchases[purchase_index].day <= day) {
            total_cakes += purchases[purchase_index].count;
            purchase_index++;
        }

        
        results[query_idx] = total_cakes;
    }

    
    for (int i = 0; i < Q; i++) {
        cout << results[i] << endl;
    }

    return 0;
}