#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0);

    long long vasarlasok_szama, kerdesek_szama;
    cin>>vasarlasok_szama>>kerdesek_szama;

    vector<pair<long long, long long>>vasarlasok(vasarlasok_szama);
    vector<long long>kerdesek(kerdesek_szama);

    for(int i=0;i<vasarlasok_szama;i++)
    {
        cin>>vasarlasok[i].first>>vasarlasok[i].second;
    }

    for(int i=0;i<kerdesek_szama;i++)
    {
        cin>>kerdesek[i];
    }

    vector<long long> kumulativ_napok, kumulativ_kekszek;
    long long osszes_keksz=0;

    for(const auto &vasarlas:vasarlasok)
    {
        kumulativ_napok.push_back(vasarlas.first);
        osszes_keksz+=vasarlas.second;
        kumulativ_kekszek.push_back(osszes_keksz);
    }

    vector<long long> eredmenyek(kerdesek_szama);
    for(int i=0;i<kerdesek_szama;i++)
    {
        long long kerdes_napja=kerdesek[i];

        auto iter=upper_bound(kumulativ_napok.begin(), kumulativ_napok.end(), kerdes_napja);
        long long elfogyasztott_kekszek=0;

        if(iter!=kumulativ_napok.begin())
        {
            int index=iter-kumulativ_napok.begin()-1;
            elfogyasztott_kekszek=kumulativ_kekszek[index];
        }

        long long maradek_napok=max(0LL, kerdes_napja-kumulativ_napok.back());
        elfogyasztott_kekszek-=max(0LL, osszes_keksz-maradek_napok);

        eredmenyek[i]=max(elfogyasztott_kekszek, 0LL);
    }

    for(const auto &eredmeny:eredmenyek)
    {
        cout<<eredmeny<<'\n';
    }

    return 0;
}