#include <iostream>
#include <vector>
#include <queue>

using namespace std;

// Smer kretanja
int dx[4] = { -1, 1, 0, 0 }; 
int dy[4] = { 0, 0, -1, 1 };

void sirenjePozara(const vector<vector<char>>& lavirint, vector<vector<int>>& vreme_dolaska_pozara, int N, int M) {
    queue<pair<int, int>> q;

    
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            if (lavirint[i][j] == 'X') {
                q.push({ i, j });
                vreme_dolaska_pozara[i][j] = 0; 
            }
            else {
                vreme_dolaska_pozara[i][j] = INT_MAX; 
            }
        }
    }

    // BFS
    while (!q.empty()) {
        int x  = q.front().first;
        int y  = q.front().second;
        q.pop();

        for (int d = 0; d < 4; ++d) {
            int nx = x + dx[d];
            int ny = y + dy[d];

            if (nx >= 0 && ny >= 0 && nx < N && ny < M && lavirint[nx][ny] == '.' && vreme_dolaska_pozara[nx][ny] == INT_MAX) {
                vreme_dolaska_pozara[nx][ny] = vreme_dolaska_pozara[x][y] + 1;
                q.push({ nx, ny });
            }
        }
    }
}


int izracujanBrojKoraka(const vector<vector<char>>& lavirint, const vector<vector<int>>& vreme_dolaska_pozara, int pocetna_pozicija_x, int pocetna_pozicija_y, int N, int M) {
    queue<pair<int, int>> q;  
    vector<vector<bool>> posecena_polja(N, vector<bool>(M, false)); 
    int reachableSpaces = 0;

    q.push({ pocetna_pozicija_x, pocetna_pozicija_y });
    posecena_polja[pocetna_pozicija_x][pocetna_pozicija_y] = true;

    int currentTime = 0;

    while (!q.empty()) {
        int size = q.size();
        while (size--) {
            int x =  q.front().first;
            int y =  q.front().second;
            q.pop();

            reachableSpaces++;

            for (int d = 0; d < 4; ++d) {
                int nx = x + dx[d];
                int ny = y + dy[d];

                if (nx >= 0 && ny >= 0 && nx < N && ny < M && !posecena_polja[nx][ny] &&
                    lavirint[nx][ny] == '.' && vreme_dolaska_pozara[nx][ny] > currentTime + 1) {
                    posecena_polja[nx][ny] = true;
                    q.push({ nx, ny });
                }
            }
        }
        currentTime++;
    }

    return reachableSpaces;
}





int main() {
    int N, M;
    cin >> N >> M; 

    vector<vector<char>> lavirint(N, vector<char>(M));

   
    
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            cin >> lavirint[i][j];
        }
    }
    vector<vector<int>> vreme_dolaska_pozara(N, vector<int>(M));

    sirenjePozara(lavirint, vreme_dolaska_pozara, N, M);

    int pocetna_pozicija_x;
    int pocetna_pozicija_y;

    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            if (lavirint[i][j] == 'S') {
                pocetna_pozicija_x = i;
                pocetna_pozicija_y = j;
            }
        }
    }

    int resultat = izracujanBrojKoraka(lavirint, vreme_dolaska_pozara, pocetna_pozicija_x, pocetna_pozicija_y, N, M);

    cout << resultat << std;

    return 0;
}