#include <iostream>
#include <queue>
#include <vector>
using namespace std;

int n, m, br = 0;
vector<string> a;

vector<vector<bool>> visitedFire, visitedSteva;

int dx[] = {-1, 1, 0, 0};  
int dy[] = {0, 0, -1, 1};

bool isValid(int x, int y) {
    return x >= 0 && x < n && y >= 0 && y < m && a[x][y] != '*';
}

void bfsFire(queue<pair<int, int>>& fireQueue) {
    while (!fireQueue.empty()) {
        auto [x, y] = fireQueue.front();
        fireQueue.pop();

        for (int d = 0; d < 4; d++) {
            int nx = x + dx[d], ny = y + dy[d];
            if (isValid(nx, ny) && !visitedFire[nx][ny] && a[nx][ny] == '.') {
                visitedFire[nx][ny] = true;
                a[nx][ny] = 'X'; 
                fireQueue.push({nx, ny});
            }
        }
    }
}

void bfsSteva(queue<pair<int, int>>& stevaQueue) {
    while (!stevaQueue.empty()) {
        auto [x, y] = stevaQueue.front();
        stevaQueue.pop();

        for (int d = 0; d < 4; d++) {
            int nx = x + dx[d], ny = y + dy[d];
            if (isValid(nx, ny) && !visitedSteva[nx][ny] && a[nx][ny] == '.') {
                visitedSteva[nx][ny] = true;
                a[nx][ny] = 'S'; 
                br++;
                stevaQueue.push({nx, ny});
            }
        }
    }
}

int main() {
    cin >> n >> m;
    a.resize(n);
    visitedFire = vector<vector<bool>>(n, vector<bool>(m, false));
    visitedSteva = vector<vector<bool>>(n, vector<bool>(m, false));

    queue<pair<int, int>> fireQueue;
    queue<pair<int, int>> stevaQueue;

    for (int i = 0; i < n; i++) {
        cin >> a[i];
        for (int j = 0; j < m; j++) {
            if (a[i][j] == 'X') {
                fireQueue.push({i, j});
                visitedFire[i][j] = true;
            }
            if (a[i][j] == 'S') {
                stevaQueue.push({i, j});
                visitedSteva[i][j] = true;
            }
        }
    }

    bfsFire(fireQueue);
    bfsSteva(stevaQueue);

    cout << br + 1 << endl;
    return 0;
}