import java.util.Scanner;
import java.util.Queue;
import java.util.LinkedList;
public class Main {
    static int[] direction_x = {-1, 1, 0, 0};
    static int[] direction_y = {0, 0, -1, 1};
    static char[] symbols = {'.', '*', 'X', 'S'};
    public static void addToQueue(Queue<int[]> queue, char[][] game_matrix, int[][] directionMatrix, int n, int m) {
        while (!queue.isEmpty()) {
            int[] current = queue.poll();
            int x = current[0], y = current[1];
            for (int i = 0; i < 4; i++) {
                int nx = x + direction_x[i], ny = y + direction_y[i];
                if (nx >= 0 && ny >= 0 && nx < n && ny < m && game_matrix[nx][ny] == symbols[0] && directionMatrix[nx][ny] == Integer.MAX_VALUE) {
                    directionMatrix[nx][ny] = directionMatrix[x][y] + 1;
                    queue.add(new int[]{nx, ny});
                }
            }
        }
    }
    public static int calculateResult(char[][] matrix, int[][] stevaMatrix, int[][] fireMatrix, int n, int m) {
        int res = 1;
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                if (matrix[i][j] == '.' && stevaMatrix[i][j] < fireMatrix[i][j]) {
                    res++;
                }
            }
        }
        return res;
    }
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int n = sc.nextInt();
        int m = sc.nextInt();
        sc.nextLine();
        char[][] matrix = new char[n][m];
        int[][] fireMatrix = new int[n][m];
        int[][] stevaMatrix = new int[n][m];
        Queue<int[]> fireQueue = new LinkedList<>();
        Queue<int[]> stevaQueue = new LinkedList<>();
        int stevaX = -1;
        int stevaY = -1;
        for (int i = 0; i < n; i++) {
            String line = sc.nextLine();
            for (int j = 0; j < m; j++) {
                matrix[i][j] = line.charAt(j);
                if (matrix[i][j] == symbols[2]) {
                    fireQueue.add(new int[]{i, j});
                    fireMatrix[i][j] = 0;
                } else if (matrix[i][j] == symbols[3]) {
                    stevaX = i;
                    stevaY = j;
                    stevaMatrix[i][j] = 0;
                } else {
                    fireMatrix[i][j] = Integer.MAX_VALUE;
                    stevaMatrix[i][j] = Integer.MAX_VALUE;
                }
            }
        }
        addToQueue(fireQueue, matrix, fireMatrix, n, m);
        stevaQueue.add(new int[]{stevaX, stevaY});
        stevaMatrix[stevaX][stevaY] = 0;
        addToQueue(stevaQueue, matrix, stevaMatrix, n, m);
        int res = calculateResult(matrix, stevaMatrix, fireMatrix, n, m);
        System.out.println(res);
    }
}