using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        // Ucitavanje ulaza
        var input = Console.ReadLine().Split();
        int N = int.Parse(input[0]); // Broj kupovina
        int Q = int.Parse(input[1]); // Broj pitanja

        var purchases = new List<(long day, long packs)>();
        for (int i = 0; i < N; i++)
        {
            var line = Console.ReadLine().Split();
            long day = long.Parse(line[0]);
            long packs = long.Parse(line[1]);
            purchases.Add((day, packs));
        }

        var queries = new List<(long day, int index)>();
        for (int i = 0; i < Q; i++)
        {
            long day = long.Parse(Console.ReadLine());
            queries.Add((day, i));
        }

        // Sortiranje kupovina i upita
        purchases.Sort((a, b) => a.day.CompareTo(b.day));
        queries.Sort((a, b) => a.day.CompareTo(b.day));

        // Priprema pratecih podataka
        var prefixSum = new long[N];
        prefixSum[0] = purchases[0].packs;
        for (int i = 1; i < N; i++)
        {
            prefixSum[i] = prefixSum[i - 1] + purchases[i].packs;
        }

        // Obrada upita
        var results = new long[Q];
        long consumed = 0;
        long lastDay = 0;
        int purchaseIndex = 0;

        foreach (var query in queries)
        {
            long day = query.day;

            // Ažuriranje potrošnje do prethodnog dana
            if (day > lastDay)
            {
                consumed += day - lastDay - 1;
                lastDay = day - 1;
            }

            // Traženje ukupno dostupnih pakovanja do tog dana
            while (purchaseIndex < N && purchases[purchaseIndex].day <= day - 1)
            {
                purchaseIndex++;
            }

            long available = purchaseIndex > 0 ? prefixSum[purchaseIndex - 1] : 0;
            results[query.index] = Math.Max(0, available - consumed);
        }

        // Ispis rezultata
        Console.WriteLine(string.Join("\n", results));
    }
}