#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
using namespace std;

int main() {
    int N, Q; // N days of candy purchases, Q queries
    cin >> N >> Q;

    map<int, int> candyPurchases; // Store candies purchased on specific days
    for (int i = 0; i < N; i++) {
        int D, P;
        cin >> D >> P;
        candyPurchases[D] += P; // Add candies for day D
    }

    vector<int> queries(Q); // Queries to store days
    for (int i = 0; i < Q; i++) {
        cin >> queries[i];
    }

    // Simulate candies and eating process
    int maxDay = 0;
    for (const auto &entry : candyPurchases) {
        maxDay = max(maxDay, entry.first);
    }
    for (int query : queries) {
        maxDay = max(maxDay, query);
    }

    int candiesAvailable = 0;
    int candiesEaten = 0;
    map<int, int> eatenUpTo; // Store cumulative candies eaten up to each day

    for (int day = 1; day <= maxDay; day++) {
        // Add candies bought on this day
        if (candyPurchases.find(day) != candyPurchases.end()) {
            candiesAvailable += candyPurchases[day];
        }

        // Eat one candy if available
        if (candiesAvailable > 0) {
            candiesEaten++;
            candiesAvailable--;
        }

        // Save the cumulative candies eaten
        eatenUpTo[day] = candiesEaten;
    }

    // Answer the queries
    for (int i = 0; i < Q; i++) {
        int K = queries[i];
        if (K > maxDay) {
            cout << eatenUpTo[maxDay] << endl; // Beyond maxDay, result is the same
        } else {
            cout << eatenUpTo[K] << endl; // Result for day K
        }
    }

    return 0;
}