#include <bits/stdc++.h>

using namespace std;

pair<int, int> shift[4] = {{-1, 0}, {0, 1}, {1, 0}, {0, -1}};

bool is_field(int i, int j, int n, int m) {
  return i >= 0 && i < n && j >= 0 && j < m;
}

int bfs(pair<int, int> start, vector<vector<char>> &maze,
        queue<pair<int, int>> &xpos, int len) {
  queue<pair<int, int>> toDo;
  toDo.push(start);
  int result = 1;

  while (!toDo.empty()) {
    int level_size = toDo.size();
    int new_len = 0;
    for (int k = 0; k < len; k++) {
      auto pos = xpos.front();
      xpos.pop();

      for (auto x : shift) {
        int i = pos.first + x.first;
        int j = pos.second + x.second;
        if (is_field(i, j, maze.size(), maze[0].size()) && maze[i][j] != 'X' &&
            maze[i][j] != '*') {
          maze[i][j] = 'X';
          new_len++;
          xpos.push({i, j});
        }
      }
    }

    len = new_len;
    for (int l = 0; l < level_size; l++) {
      auto cur = toDo.front();
      toDo.pop();
      for (auto x : shift) {
        int i = cur.first + x.first;
        int j = cur.second + x.second;
        if (is_field(i, j, maze.size(), maze[0].size()) && maze[i][j] == '.') {
          maze[i][j] = 'S';
          result++;
          toDo.push({i, j});
        }
      }
    }
  }

  return result;
}

int main() {
  int n, m, len = 0;
  char newline;
  cin >> n >> m;

  vector<vector<char>> maze(n, vector<char>(m));
  queue<pair<int, int>> xpos;
  pair<int, int> spos;
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < m; j++) {
      cin >> maze[i][j];
      if (maze[i][j] == 'X') {
        xpos.push({i, j});
        len++;
      } else if (maze[i][j] == 'S') {
        spos = {i, j};
      }
    }
  }

  cout << bfs(spos, maze, xpos, len) << endl;
  return 0;
}