#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

struct Purchase {
    long long day;
    long long packages;
};

int main() {
    
    int N, Q;
    cin >> N >> Q;

    vector<Purchase> purchases(N);
    for (int i = 0; i < N; i++) {
        cin >> purchases[i].day >> purchases[i].packages;
    }

    vector<long long> queries(Q);
    for (int i = 0; i < Q; i++) {
        cin >> queries[i];
    }

    
    vector<long long> cumulative_sum(N + 1, 0);
    for (int i = 0; i < N; i++) {
        cumulative_sum[i + 1] = cumulative_sum[i] + purchases[i].packages;
    }

   
    for (int i = 0; i < Q; i++) {
        long long k = queries[i];

        
        auto it = upper_bound(purchases.begin(), purchases.end(), k,
                              [](long long k, const Purchase& p) { return k < p.day; });

        int idx = it - purchases.begin(); 
        long long total_packages = cumulative_sum[idx]; 

        
        long long days_eaten = k;

       
        results[i] = min(total_packages, days_eaten);
    }

   
    for (int i = 0; i < Q; i++) {
        cout << results[i] << endl;
    }

    return 0;
}